"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalJson = exports.GlobalJsonSchema = void 0;
const zod_1 = require("zod");
const schema_utils_1 = require("../../../util/schema-utils");
/**
 * The roll-forward policy to use when selecting an SDK version, either as a fallback when a specific SDK version is missing or as a directive to use a later version. A version must be specified with a rollForward value, unless you're setting it to latestMajor. The default roll forward behavior is determined by the matching rules.
 *
 * https://learn.microsoft.com/de-de/dotnet/core/tools/global-json#rollforward
 */
const RollForwardSchema = zod_1.z.enum([
    'patch',
    'feature',
    'minor',
    'major',
    'latestPatch',
    'latestFeature',
    'latestMinor',
    'latestMajor',
    'disable',
]);
/**
 * global.json schema
 *
 * https://learn.microsoft.com/en-us/dotnet/core/tools/global-json#allowprerelease
 */
exports.GlobalJsonSchema = zod_1.z.object({
    /**
     * Specifies information about the .NET SDK to select.
     */
    sdk: zod_1.z
        .object({
        /**
         * The version of the .NET SDK to use.
         *
         * https://learn.microsoft.com/de-de/dotnet/core/tools/global-json#version
         */
        version: zod_1.z.string().optional(),
        /**
         * The roll-forward policy to use when selecting an SDK version, either as a fallback when a specific SDK version is missing or as a directive to use a later version. A version must be specified with a rollForward value, unless you're setting it to latestMajor. The default roll forward behavior is determined by the matching rules.
         *
         * https://learn.microsoft.com/de-de/dotnet/core/tools/global-json#rollforward
         */
        rollForward: RollForwardSchema.optional(),
        /**
         * Indicates whether the SDK resolver should consider prerelease versions when selecting the SDK version to use.
         *
         * https://learn.microsoft.com/de-de/dotnet/core/tools/global-json#allowprerelease
         */
        allowPrerelease: zod_1.z.boolean().optional(),
    })
        .optional(),
    /**
     * Lets you control the project SDK version in one place rather than in each individual project. For more information, see How project SDKs are resolved.
     *
     * https://learn.microsoft.com/de-de/dotnet/core/tools/global-json#msbuild-sdks
     */
    'msbuild-sdks': zod_1.z.record(zod_1.z.string()).optional(),
});
exports.GlobalJson = schema_utils_1.Jsonc.pipe(exports.GlobalJsonSchema);
//# sourceMappingURL=schema.js.map