"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.displayName = exports.bumpPackageVersion = exports.updateArtifacts = exports.extractPackageFile = void 0;
const docker_1 = require("../../datasource/docker");
const dotnet_version_1 = require("../../datasource/dotnet-version");
const nuget_1 = require("../../datasource/nuget");
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
var artifacts_1 = require("./artifacts");
Object.defineProperty(exports, "updateArtifacts", { enumerable: true, get: function () { return artifacts_1.updateArtifacts; } });
var update_1 = require("./update");
Object.defineProperty(exports, "bumpPackageVersion", { enumerable: true, get: function () { return update_1.bumpPackageVersion; } });
exports.displayName = 'NuGet';
exports.url = 'https://learn.microsoft.com/nuget';
exports.categories = ['dotnet'];
exports.defaultConfig = {
    managerFilePatterns: [
        '/\\.(?:cs|fs|vb)proj$/',
        '/\\.(?:props|targets)$/',
        '/(^|/)dotnet-tools\\.json$/',
        '/(^|/)global\\.json$/',
    ],
};
exports.supportedDatasources = [
    docker_1.DockerDatasource.id,
    dotnet_version_1.DotnetVersionDatasource.id,
    nuget_1.NugetDatasource.id,
];
//# sourceMappingURL=index.js.map