"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackageLock = exports.PackageLockPreV3Schema = exports.PackageLockV3Schema = exports.PackageJson = exports.PackageJsonSchema = exports.PackageManagerSchema = exports.PnpmWorkspaceFileSchema = exports.PnpmCatalogsSchema = void 0;
const zod_1 = require("zod");
const schema_utils_1 = require("../../../util/schema-utils");
exports.PnpmCatalogsSchema = zod_1.z.object({
    catalog: zod_1.z.optional(zod_1.z.record(zod_1.z.string())),
    catalogs: zod_1.z.optional(zod_1.z.record(zod_1.z.record(zod_1.z.string()))),
});
exports.PnpmWorkspaceFileSchema = zod_1.z
    .object({
    packages: zod_1.z.array(zod_1.z.string()),
})
    .and(exports.PnpmCatalogsSchema);
exports.PackageManagerSchema = zod_1.z
    .string()
    .transform((val) => val.split('@'))
    .transform(([name, ...version]) => ({ name, version: version.join('@') }));
const DevEngineDependency = zod_1.z.object({
    name: zod_1.z.string(),
    version: zod_1.z.string().optional(),
});
const DevEngineSchema = zod_1.z.object({
    packageManager: DevEngineDependency.or(zod_1.z.array(DevEngineDependency)).optional(),
});
exports.PackageJsonSchema = zod_1.z.object({
    devEngines: DevEngineSchema.optional(),
    engines: (0, schema_utils_1.LooseRecord)(zod_1.z.string()).optional(),
    dependencies: (0, schema_utils_1.LooseRecord)(zod_1.z.string()).optional(),
    devDependencies: (0, schema_utils_1.LooseRecord)(zod_1.z.string()).optional(),
    peerDependencies: (0, schema_utils_1.LooseRecord)(zod_1.z.string()).optional(),
    packageManager: exports.PackageManagerSchema.optional(),
    volta: (0, schema_utils_1.LooseRecord)(zod_1.z.string()).optional(),
});
exports.PackageJson = schema_utils_1.Json.pipe(exports.PackageJsonSchema);
exports.PackageLockV3Schema = zod_1.z.object({
    lockfileVersion: zod_1.z.literal(3),
    packages: (0, schema_utils_1.LooseRecord)(zod_1.z
        .string()
        .transform((x) => x.replace(/^node_modules\//, ''))
        .refine((x) => x.trim() !== ''), zod_1.z.object({ version: zod_1.z.string() })),
});
exports.PackageLockPreV3Schema = zod_1.z
    .object({
    lockfileVersion: zod_1.z.union([zod_1.z.literal(2), zod_1.z.literal(1)]),
    dependencies: (0, schema_utils_1.LooseRecord)(zod_1.z.object({ version: zod_1.z.string() })),
})
    .transform(({ lockfileVersion, dependencies: packages }) => ({
    lockfileVersion,
    packages,
}));
exports.PackageLock = schema_utils_1.Json.pipe(zod_1.z.union([exports.PackageLockV3Schema, exports.PackageLockPreV3Schema])).transform(({ packages, lockfileVersion }) => {
    const lockedVersions = {};
    for (const [entry, val] of Object.entries(packages)) {
        lockedVersions[entry] = val.version;
    }
    return { lockedVersions, lockfileVersion };
});
//# sourceMappingURL=schema.js.map