import { z } from 'zod';
export declare const PnpmCatalogsSchema: z.ZodObject<{
    catalog: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    catalogs: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodRecord<z.ZodString, z.ZodString>>>;
}, "strip", z.ZodTypeAny, {
    catalog?: Record<string, string> | undefined;
    catalogs?: Record<string, Record<string, string>> | undefined;
}, {
    catalog?: Record<string, string> | undefined;
    catalogs?: Record<string, Record<string, string>> | undefined;
}>;
export declare const PnpmWorkspaceFileSchema: z.ZodIntersection<z.ZodObject<{
    packages: z.ZodArray<z.ZodString, "many">;
}, "strip", z.ZodTypeAny, {
    packages: string[];
}, {
    packages: string[];
}>, z.ZodObject<{
    catalog: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    catalogs: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodRecord<z.ZodString, z.ZodString>>>;
}, "strip", z.ZodTypeAny, {
    catalog?: Record<string, string> | undefined;
    catalogs?: Record<string, Record<string, string>> | undefined;
}, {
    catalog?: Record<string, string> | undefined;
    catalogs?: Record<string, Record<string, string>> | undefined;
}>>;
export declare const PackageManagerSchema: z.ZodEffects<z.ZodEffects<z.ZodString, string[], string>, {
    name: string;
    version: string;
}, string>;
export declare const PackageJsonSchema: z.ZodObject<{
    devEngines: z.ZodOptional<z.ZodObject<{
        packageManager: z.ZodOptional<z.ZodUnion<[z.ZodObject<{
            name: z.ZodString;
            version: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            name: string;
            version?: string | undefined;
        }, {
            name: string;
            version?: string | undefined;
        }>, z.ZodArray<z.ZodObject<{
            name: z.ZodString;
            version: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            name: string;
            version?: string | undefined;
        }, {
            name: string;
            version?: string | undefined;
        }>, "many">]>>;
    }, "strip", z.ZodTypeAny, {
        packageManager?: {
            name: string;
            version?: string | undefined;
        } | {
            name: string;
            version?: string | undefined;
        }[] | undefined;
    }, {
        packageManager?: {
            name: string;
            version?: string | undefined;
        } | {
            name: string;
            version?: string | undefined;
        }[] | undefined;
    }>>;
    engines: z.ZodOptional<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, string>, Record<string, any>>>;
    dependencies: z.ZodOptional<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, string>, Record<string, any>>>;
    devDependencies: z.ZodOptional<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, string>, Record<string, any>>>;
    peerDependencies: z.ZodOptional<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, string>, Record<string, any>>>;
    packageManager: z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodString, string[], string>, {
        name: string;
        version: string;
    }, string>>;
    volta: z.ZodOptional<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, string>, Record<string, any>>>;
}, "strip", z.ZodTypeAny, {
    dependencies?: Record<string, string> | undefined;
    devDependencies?: Record<string, string> | undefined;
    peerDependencies?: Record<string, string> | undefined;
    engines?: Record<string, string> | undefined;
    packageManager?: {
        name: string;
        version: string;
    } | undefined;
    volta?: Record<string, string> | undefined;
    devEngines?: {
        packageManager?: {
            name: string;
            version?: string | undefined;
        } | {
            name: string;
            version?: string | undefined;
        }[] | undefined;
    } | undefined;
}, {
    dependencies?: Record<string, any> | undefined;
    devDependencies?: Record<string, any> | undefined;
    peerDependencies?: Record<string, any> | undefined;
    engines?: Record<string, any> | undefined;
    packageManager?: string | undefined;
    volta?: Record<string, any> | undefined;
    devEngines?: {
        packageManager?: {
            name: string;
            version?: string | undefined;
        } | {
            name: string;
            version?: string | undefined;
        }[] | undefined;
    } | undefined;
}>;
export type PackageJsonSchema = z.infer<typeof PackageJsonSchema>;
export declare const PackageJson: z.ZodPipeline<z.ZodEffects<z.ZodString, string | number | boolean | import("type-fest").JsonObject | import("type-fest").JsonValue[] | readonly import("type-fest").JsonValue[] | null, string>, z.ZodObject<{
    devEngines: z.ZodOptional<z.ZodObject<{
        packageManager: z.ZodOptional<z.ZodUnion<[z.ZodObject<{
            name: z.ZodString;
            version: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            name: string;
            version?: string | undefined;
        }, {
            name: string;
            version?: string | undefined;
        }>, z.ZodArray<z.ZodObject<{
            name: z.ZodString;
            version: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            name: string;
            version?: string | undefined;
        }, {
            name: string;
            version?: string | undefined;
        }>, "many">]>>;
    }, "strip", z.ZodTypeAny, {
        packageManager?: {
            name: string;
            version?: string | undefined;
        } | {
            name: string;
            version?: string | undefined;
        }[] | undefined;
    }, {
        packageManager?: {
            name: string;
            version?: string | undefined;
        } | {
            name: string;
            version?: string | undefined;
        }[] | undefined;
    }>>;
    engines: z.ZodOptional<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, string>, Record<string, any>>>;
    dependencies: z.ZodOptional<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, string>, Record<string, any>>>;
    devDependencies: z.ZodOptional<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, string>, Record<string, any>>>;
    peerDependencies: z.ZodOptional<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, string>, Record<string, any>>>;
    packageManager: z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodString, string[], string>, {
        name: string;
        version: string;
    }, string>>;
    volta: z.ZodOptional<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, string>, Record<string, any>>>;
}, "strip", z.ZodTypeAny, {
    dependencies?: Record<string, string> | undefined;
    devDependencies?: Record<string, string> | undefined;
    peerDependencies?: Record<string, string> | undefined;
    engines?: Record<string, string> | undefined;
    packageManager?: {
        name: string;
        version: string;
    } | undefined;
    volta?: Record<string, string> | undefined;
    devEngines?: {
        packageManager?: {
            name: string;
            version?: string | undefined;
        } | {
            name: string;
            version?: string | undefined;
        }[] | undefined;
    } | undefined;
}, {
    dependencies?: Record<string, any> | undefined;
    devDependencies?: Record<string, any> | undefined;
    peerDependencies?: Record<string, any> | undefined;
    engines?: Record<string, any> | undefined;
    packageManager?: string | undefined;
    volta?: Record<string, any> | undefined;
    devEngines?: {
        packageManager?: {
            name: string;
            version?: string | undefined;
        } | {
            name: string;
            version?: string | undefined;
        }[] | undefined;
    } | undefined;
}>>;
export declare const PackageLockV3Schema: z.ZodObject<{
    lockfileVersion: z.ZodLiteral<3>;
    packages: z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
        version: string;
    }>, Record<string, any>>;
}, "strip", z.ZodTypeAny, {
    lockfileVersion: 3;
    packages: Record<string, {
        version: string;
    }>;
}, {
    lockfileVersion: 3;
    packages: Record<string, any>;
}>;
export declare const PackageLockPreV3Schema: z.ZodEffects<z.ZodObject<{
    lockfileVersion: z.ZodUnion<[z.ZodLiteral<2>, z.ZodLiteral<1>]>;
    dependencies: z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
        version: string;
    }>, Record<string, any>>;
}, "strip", z.ZodTypeAny, {
    dependencies: Record<string, {
        version: string;
    }>;
    lockfileVersion: 1 | 2;
}, {
    dependencies: Record<string, any>;
    lockfileVersion: 1 | 2;
}>, {
    lockfileVersion: 1 | 2;
    packages: Record<string, {
        version: string;
    }>;
}, {
    dependencies: Record<string, any>;
    lockfileVersion: 1 | 2;
}>;
export declare const PackageLock: z.ZodEffects<z.ZodPipeline<z.ZodEffects<z.ZodString, string | number | boolean | import("type-fest").JsonObject | import("type-fest").JsonValue[] | readonly import("type-fest").JsonValue[] | null, string>, z.ZodUnion<[z.ZodObject<{
    lockfileVersion: z.ZodLiteral<3>;
    packages: z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
        version: string;
    }>, Record<string, any>>;
}, "strip", z.ZodTypeAny, {
    lockfileVersion: 3;
    packages: Record<string, {
        version: string;
    }>;
}, {
    lockfileVersion: 3;
    packages: Record<string, any>;
}>, z.ZodEffects<z.ZodObject<{
    lockfileVersion: z.ZodUnion<[z.ZodLiteral<2>, z.ZodLiteral<1>]>;
    dependencies: z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
        version: string;
    }>, Record<string, any>>;
}, "strip", z.ZodTypeAny, {
    dependencies: Record<string, {
        version: string;
    }>;
    lockfileVersion: 1 | 2;
}, {
    dependencies: Record<string, any>;
    lockfileVersion: 1 | 2;
}>, {
    lockfileVersion: 1 | 2;
    packages: Record<string, {
        version: string;
    }>;
}, {
    dependencies: Record<string, any>;
    lockfileVersion: 1 | 2;
}>]>>, {
    lockedVersions: Record<string, string>;
    lockfileVersion: 1 | 2 | 3;
}, string>;
