"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.lazyLoadPackageJson = lazyLoadPackageJson;
exports.loadPackageJson = loadPackageJson;
exports.getPackageManagerVersion = getPackageManagerVersion;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const semver_1 = tslib_1.__importDefault(require("semver"));
const upath_1 = tslib_1.__importDefault(require("upath"));
const logger_1 = require("../../../../logger");
const fs_1 = require("../../../../util/fs");
const lazy_1 = require("../../../../util/lazy");
const schema_1 = require("../schema");
function lazyLoadPackageJson(lockFileDir) {
    return new lazy_1.Lazy(() => loadPackageJson(lockFileDir));
}
async function loadPackageJson(lockFileDir) {
    const json = await (0, fs_1.readLocalFile)(upath_1.default.join(lockFileDir, 'package.json'), 'utf8');
    const res = schema_1.PackageJson.safeParse(json);
    if (res.success) {
        return res.data;
    }
    return {};
}
function getPackageManagerVersion(name, pkg) {
    if (pkg.volta?.[name]) {
        const version = pkg.volta[name];
        logger_1.logger.debug(`Found ${name} constraint in package.json volta: ${version}`);
        return version;
    }
    if (pkg.devEngines?.packageManager) {
        const packageManagers = is_1.default.array(pkg.devEngines.packageManager)
            ? pkg.devEngines.packageManager
            : [pkg.devEngines.packageManager];
        const packageMgr = packageManagers.find((pm) => pm.name === name);
        const version = packageMgr?.version;
        if (version) {
            logger_1.logger.debug(`Found ${name} constraint in package.json devEngines: ${version}`);
            return version;
        }
    }
    if (pkg.packageManager?.name === name) {
        const version = pkg.packageManager.version;
        logger_1.logger.debug(`Found ${name} constraint in package.json packageManager: ${version}`);
        if (semver_1.default.valid(version)) {
            return version;
        }
        return null;
    }
    if (pkg.engines?.[name]) {
        const version = pkg.engines[name];
        logger_1.logger.debug(`Found ${name} constraint in package.json engines: ${version}`);
        return version;
    }
    return null;
}
//# sourceMappingURL=utils.js.map