import { z } from 'zod';
declare const YarnrcYmlSchema: z.ZodPipeline<z.ZodEffects<z.ZodString, string | number | boolean | import("type-fest").JsonObject | import("type-fest").JsonValue[] | readonly import("type-fest").JsonValue[] | null, string>, z.ZodObject<{
    npmRegistryServer: z.ZodOptional<z.ZodString>;
    npmScopes: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodObject<{
        npmRegistryServer: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        npmRegistryServer?: string | undefined;
    }, {
        npmRegistryServer?: string | undefined;
    }>>>;
}, "strip", z.ZodTypeAny, {
    npmRegistryServer?: string | undefined;
    npmScopes?: Record<string, {
        npmRegistryServer?: string | undefined;
    }> | undefined;
}, {
    npmRegistryServer?: string | undefined;
    npmScopes?: Record<string, {
        npmRegistryServer?: string | undefined;
    }> | undefined;
}>>;
export type YarnConfig = z.infer<typeof YarnrcYmlSchema>;
export declare function loadConfigFromLegacyYarnrc(legacyYarnrc: string): YarnConfig | null;
export declare function loadConfigFromYarnrcYml(yarnrcYml: string): YarnConfig | null;
export declare function resolveRegistryUrl(packageName: string, yarnConfig: YarnConfig): string | null;
export {};
