"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.matchesAnyPattern = matchesAnyPattern;
const logger_1 = require("../../../../logger");
const minimatch_1 = require("../../../../util/minimatch");
function matchesAnyPattern(val, patterns) {
    const res = patterns.some((pattern) => pattern === `${val}/` || (0, minimatch_1.minimatch)(pattern, { dot: true }).match(val));
    logger_1.logger.trace({ val, patterns, res }, `matchesAnyPattern`);
    return res;
}
//# sourceMappingURL=utils.js.map