"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractOverrideDepsRec = extractOverrideDepsRec;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const dependency_1 = require("./dependency");
const node_1 = require("./node");
/**
 * Used when there is a json object as a value in overrides block.
 * @param parents
 * @param child
 * @returns PackageDependency array
 */
function extractOverrideDepsRec(parents, child) {
    const deps = [];
    if (!child || is_1.default.emptyObject(child)) {
        return deps;
    }
    for (const [overrideName, versionValue] of Object.entries(child)) {
        if (is_1.default.string(versionValue)) {
            // special handling for "." override dependency name
            // "." means the constraint is applied to the parent dep
            const currDepName = overrideName === '.' ? parents[parents.length - 1] : overrideName;
            const dep = {
                depName: currDepName,
                depType: 'overrides',
                managerData: { parents: parents.slice() }, // set parents for dependency
            };
            (0, node_1.setNodeCommitTopic)(dep);
            deps.push({
                ...dep,
                ...(0, dependency_1.extractDependency)('overrides', currDepName, versionValue),
            });
        }
        else {
            // versionValue is an object, run recursively.
            parents.push(overrideName);
            const depsOfObject = extractOverrideDepsRec(parents, versionValue);
            deps.push(...depsOfObject);
        }
    }
    parents.pop();
    return deps;
}
//# sourceMappingURL=overrides.js.map