import { z } from 'zod';
export declare const NixFlakeLock: z.ZodPipeline<z.ZodEffects<z.ZodString, string | number | boolean | import("type-fest").JsonObject | import("type-fest").JsonValue[] | readonly import("type-fest").JsonValue[] | null, string>, z.ZodObject<{
    nodes: z.ZodRecord<z.ZodString, z.ZodObject<{
        inputs: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>>;
        locked: z.ZodOptional<z.ZodObject<{
            ref: z.ZodOptional<z.ZodString>;
            rev: z.ZodString;
            type: z.ZodEnum<["git", "github", "gitlab", "indirect", "path", "sourcehut", "tarball"]>;
        }, "strip", z.ZodTypeAny, {
            type: "path" | "github" | "gitlab" | "git" | "indirect" | "sourcehut" | "tarball";
            rev: string;
            ref?: string | undefined;
        }, {
            type: "path" | "github" | "gitlab" | "git" | "indirect" | "sourcehut" | "tarball";
            rev: string;
            ref?: string | undefined;
        }>>;
        original: z.ZodOptional<z.ZodObject<{
            host: z.ZodOptional<z.ZodString>;
            owner: z.ZodOptional<z.ZodString>;
            repo: z.ZodOptional<z.ZodString>;
            ref: z.ZodOptional<z.ZodString>;
            type: z.ZodEnum<["git", "github", "gitlab", "indirect", "path", "sourcehut", "tarball"]>;
            url: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "path" | "github" | "gitlab" | "git" | "indirect" | "sourcehut" | "tarball";
            host?: string | undefined;
            url?: string | undefined;
            ref?: string | undefined;
            repo?: string | undefined;
            owner?: string | undefined;
        }, {
            type: "path" | "github" | "gitlab" | "git" | "indirect" | "sourcehut" | "tarball";
            host?: string | undefined;
            url?: string | undefined;
            ref?: string | undefined;
            repo?: string | undefined;
            owner?: string | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        locked?: {
            type: "path" | "github" | "gitlab" | "git" | "indirect" | "sourcehut" | "tarball";
            rev: string;
            ref?: string | undefined;
        } | undefined;
        inputs?: Record<string, string | string[]> | undefined;
        original?: {
            type: "path" | "github" | "gitlab" | "git" | "indirect" | "sourcehut" | "tarball";
            host?: string | undefined;
            url?: string | undefined;
            ref?: string | undefined;
            repo?: string | undefined;
            owner?: string | undefined;
        } | undefined;
    }, {
        locked?: {
            type: "path" | "github" | "gitlab" | "git" | "indirect" | "sourcehut" | "tarball";
            rev: string;
            ref?: string | undefined;
        } | undefined;
        inputs?: Record<string, string | string[]> | undefined;
        original?: {
            type: "path" | "github" | "gitlab" | "git" | "indirect" | "sourcehut" | "tarball";
            host?: string | undefined;
            url?: string | undefined;
            ref?: string | undefined;
            repo?: string | undefined;
            owner?: string | undefined;
        } | undefined;
    }>>;
    version: z.ZodLiteral<7>;
}, "strip", z.ZodTypeAny, {
    version: 7;
    nodes: Record<string, {
        locked?: {
            type: "path" | "github" | "gitlab" | "git" | "indirect" | "sourcehut" | "tarball";
            rev: string;
            ref?: string | undefined;
        } | undefined;
        inputs?: Record<string, string | string[]> | undefined;
        original?: {
            type: "path" | "github" | "gitlab" | "git" | "indirect" | "sourcehut" | "tarball";
            host?: string | undefined;
            url?: string | undefined;
            ref?: string | undefined;
            repo?: string | undefined;
            owner?: string | undefined;
        } | undefined;
    }>;
}, {
    version: 7;
    nodes: Record<string, {
        locked?: {
            type: "path" | "github" | "gitlab" | "git" | "indirect" | "sourcehut" | "tarball";
            rev: string;
            ref?: string | undefined;
        } | undefined;
        inputs?: Record<string, string | string[]> | undefined;
        original?: {
            type: "path" | "github" | "gitlab" | "git" | "indirect" | "sourcehut" | "tarball";
            host?: string | undefined;
            url?: string | undefined;
            ref?: string | undefined;
            repo?: string | undefined;
            owner?: string | undefined;
        } | undefined;
    }>;
}>>;
export type NixFlakeLock = z.infer<typeof NixFlakeLock>;
