"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseTomlFile = parseTomlFile;
const logger_1 = require("../../../logger");
const schema_1 = require("./schema");
function parseTomlFile(content, packageFile) {
    const res = schema_1.MiseFileSchemaToml.safeParse(content);
    if (res.success) {
        return res.data;
    }
    else {
        logger_1.logger.debug({ err: res.error, packageFile }, 'Error parsing Mise file.');
        return null;
    }
}
//# sourceMappingURL=utils.js.map