"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MiseFileSchemaToml = exports.MiseFileSchema = void 0;
const zod_1 = require("zod");
const schema_utils_1 = require("../../../util/schema-utils");
const MiseToolOptionsSchema = zod_1.z.object({
    // ubi backend only
    tag_regex: zod_1.z.string().optional(),
});
const MiseToolSchema = zod_1.z.union([
    zod_1.z.string(),
    MiseToolOptionsSchema.extend({
        version: zod_1.z.string().optional(),
    }),
    zod_1.z.array(zod_1.z.string()),
]);
exports.MiseFileSchema = zod_1.z.object({
    tools: zod_1.z.record(MiseToolSchema),
});
exports.MiseFileSchemaToml = schema_utils_1.Toml.pipe(exports.MiseFileSchema);
//# sourceMappingURL=schema.js.map