import { z } from 'zod';
declare const MiseToolOptionsSchema: z.ZodObject<{
    tag_regex: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    tag_regex?: string | undefined;
}, {
    tag_regex?: string | undefined;
}>;
export type MiseToolOptionsSchema = z.infer<typeof MiseToolOptionsSchema>;
declare const MiseToolSchema: z.ZodUnion<[z.ZodString, z.ZodObject<{
    tag_regex: z.ZodOptional<z.ZodString>;
} & {
    version: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    version?: string | undefined;
    tag_regex?: string | undefined;
}, {
    version?: string | undefined;
    tag_regex?: string | undefined;
}>, z.ZodArray<z.ZodString, "many">]>;
export type MiseToolSchema = z.infer<typeof MiseToolSchema>;
export declare const MiseFileSchema: z.ZodObject<{
    tools: z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodString, z.ZodObject<{
        tag_regex: z.ZodOptional<z.ZodString>;
    } & {
        version: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        version?: string | undefined;
        tag_regex?: string | undefined;
    }, {
        version?: string | undefined;
        tag_regex?: string | undefined;
    }>, z.ZodArray<z.ZodString, "many">]>>;
}, "strip", z.ZodTypeAny, {
    tools: Record<string, string | string[] | {
        version?: string | undefined;
        tag_regex?: string | undefined;
    }>;
}, {
    tools: Record<string, string | string[] | {
        version?: string | undefined;
        tag_regex?: string | undefined;
    }>;
}>;
export type MiseFileSchema = z.infer<typeof MiseFileSchema>;
export declare const MiseFileSchemaToml: z.ZodPipeline<z.ZodEffects<z.ZodString, unknown, string>, z.ZodObject<{
    tools: z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodString, z.ZodObject<{
        tag_regex: z.ZodOptional<z.ZodString>;
    } & {
        version: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        version?: string | undefined;
        tag_regex?: string | undefined;
    }, {
        version?: string | undefined;
        tag_regex?: string | undefined;
    }>, z.ZodArray<z.ZodString, "many">]>>;
}, "strip", z.ZodTypeAny, {
    tools: Record<string, string | string[] | {
        version?: string | undefined;
        tag_regex?: string | undefined;
    }>;
}, {
    tools: Record<string, string | string[] | {
        version?: string | undefined;
        tag_regex?: string | undefined;
    }>;
}>>;
export {};
