"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.url = exports.displayName = exports.extractPackageFile = void 0;
const array_1 = require("../../../util/array");
const crate_1 = require("../../datasource/crate");
const git_refs_1 = require("../../datasource/git-refs");
const git_tags_1 = require("../../datasource/git-tags");
const github_releases_1 = require("../../datasource/github-releases");
const github_tags_1 = require("../../datasource/github-tags");
const go_1 = require("../../datasource/go");
const java_version_1 = require("../../datasource/java-version");
const node_version_1 = require("../../datasource/node-version");
const npm_1 = require("../../datasource/npm");
const nuget_1 = require("../../datasource/nuget");
const pypi_1 = require("../../datasource/pypi");
const ruby_version_1 = require("../../datasource/ruby-version");
const rubygems_1 = require("../../datasource/rubygems");
const asdf_1 = require("../asdf");
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
exports.displayName = 'mise-en-place';
exports.url = 'https://mise.jdx.dev';
exports.defaultConfig = {
    managerFilePatterns: [
        '/(^|/)\\.?mise\\.toml$/',
        '/(^|/)\\.?mise/config\\.toml$/',
    ],
};
const backendDatasources = {
    core: [
        github_releases_1.GithubReleasesDatasource.id,
        github_tags_1.GithubTagsDatasource.id,
        java_version_1.JavaVersionDatasource.id,
        node_version_1.NodeVersionDatasource.id,
        ruby_version_1.RubyVersionDatasource.id,
    ],
    // Re-use the asdf datasources, as mise and asdf support the same plugins.
    asdf: asdf_1.supportedDatasources,
    aqua: [github_tags_1.GithubTagsDatasource.id],
    cargo: [crate_1.CrateDatasource.id, git_tags_1.GitTagsDatasource.id, git_refs_1.GitRefsDatasource.id],
    dotnet: [nuget_1.NugetDatasource.id],
    gem: [rubygems_1.RubygemsDatasource.id],
    go: [go_1.GoDatasource.id],
    npm: [npm_1.NpmDatasource.id],
    pipx: [pypi_1.PypiDatasource.id, github_tags_1.GithubTagsDatasource.id, git_refs_1.GitRefsDatasource.id],
    spm: [github_releases_1.GithubReleasesDatasource.id],
    ubi: [github_releases_1.GithubReleasesDatasource.id],
    // not supported
    vfox: [],
};
exports.supportedDatasources = (0, array_1.deduplicateArray)(Object.values(backendDatasources).flat()).sort();
//# sourceMappingURL=index.js.map