import type { PackageDependency } from '../types';
import type { MiseToolOptionsSchema } from './schema';
export type BackendToolingConfig = Omit<PackageDependency, 'depName'> & Required<Pick<PackageDependency, 'packageName' | 'datasource'> | Pick<PackageDependency, 'packageName' | 'skipReason'>>;
/**
 * Create a tooling config for aqua backend
 * @link https://mise.jdx.dev/dev-tools/backends/aqua.html
 */
export declare function createAquaToolConfig(name: string, version: string): BackendToolingConfig;
/**
 * Create a tooling config for cargo backend
 * @link https://mise.jdx.dev/dev-tools/backends/cargo.html
 */
export declare function createCargoToolConfig(name: string, version: string): BackendToolingConfig;
/**
 * Create a tooling config for dotnet backend
 * @link https://mise.jdx.dev/dev-tools/backends/dotnet.html
 */
export declare function createDotnetToolConfig(name: string): BackendToolingConfig;
/**
 * Create a tooling config for gem backend
 * @link https://mise.jdx.dev/dev-tools/backends/gem.html
 */
export declare function createGemToolConfig(name: string): BackendToolingConfig;
/**
 * Create a tooling config for go backend
 * @link https://mise.jdx.dev/dev-tools/backends/go.html
 */
export declare function createGoToolConfig(name: string): BackendToolingConfig;
/**
 * Create a tooling config for npm backend
 * @link https://mise.jdx.dev/dev-tools/backends/npm.html
 */
export declare function createNpmToolConfig(name: string): BackendToolingConfig;
/**
 * Create a tooling config for pipx backend
 * @link https://mise.jdx.dev/dev-tools/backends/pipx.html
 */
export declare function createPipxToolConfig(name: string): BackendToolingConfig;
/**
 * Create a tooling config for spm backend
 * @link https://mise.jdx.dev/dev-tools/backends/spm.html
 */
export declare function createSpmToolConfig(name: string): BackendToolingConfig;
/**
 * Create a tooling config for ubi backend
 * @link https://mise.jdx.dev/dev-tools/backends/ubi.html
 */
export declare function createUbiToolConfig(name: string, version: string, toolOptions: MiseToolOptionsSchema): BackendToolingConfig;
