"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const regex_1 = require("../../../util/regex");
const git_tags_1 = require("../../datasource/git-tags");
function extractPackageFile(content) {
    const deps = [];
    for (const line of content.split(regex_1.newlineRegex).map((s) => s.trim())) {
        if (line === '') {
            continue;
        }
        // commented out line
        if (line.startsWith('#')) {
            continue;
        }
        // commented out line after package name
        if (line.includes('#')) {
            const [uncommentLine] = line.split('#');
            deps.push(handleDepInMintfile(uncommentLine));
            continue;
        }
        deps.push(handleDepInMintfile(line));
    }
    return deps.length ? { deps } : null;
}
function handleDepInMintfile(line) {
    if (!line.includes('@')) {
        return {
            depName: line,
            skipReason: 'unspecified-version',
        };
    }
    const [depName, currentVersion] = line.split('@').map((s) => s.trim());
    return {
        depName,
        currentValue: currentVersion,
        datasource: git_tags_1.GitTagsDatasource.id,
        packageName: `https://github.com/${depName}.git`,
    };
}
//# sourceMappingURL=extract.js.map