"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.extractPackageFile = exports.updateArtifacts = void 0;
const docker_1 = require("../../datasource/docker");
const git_tags_1 = require("../../datasource/git-tags");
const github_tags_1 = require("../../datasource/github-tags");
const helm_1 = require("../../datasource/helm");
var artifacts_1 = require("./artifacts");
Object.defineProperty(exports, "updateArtifacts", { enumerable: true, get: function () { return artifacts_1.updateArtifacts; } });
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
exports.url = 'https://kubectl.docs.kubernetes.io/references/kustomize';
exports.categories = ['kubernetes'];
exports.defaultConfig = {
    managerFilePatterns: ['/(^|/)kustomization\\.ya?ml$/'],
    pinDigests: false,
};
exports.supportedDatasources = [
    docker_1.DockerDatasource.id,
    git_tags_1.GitTagsDatasource.id,
    github_tags_1.GithubTagsDatasource.id,
    helm_1.HelmDatasource.id,
];
//# sourceMappingURL=index.js.map