import type { ExtractConfig, PackageDependency, PackageFileContent } from '../types';
import type { HelmChart, Image, Kustomize } from './types';
export declare function extractResource(base: string): PackageDependency | null;
export declare function extractImage(image: Image, aliases?: Record<string, string>): PackageDependency | null;
export declare function extractHelmChart(helmChart: HelmChart, aliases?: Record<string, string>): PackageDependency | null;
export declare function parseKustomize(content: string, packageFile?: string): Kustomize | null;
export declare function extractPackageFile(content: string, packageFile: string, config: ExtractConfig): PackageFileContent | null;
