"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const upath_1 = require("upath");
const logger_1 = require("../../../logger");
const array_1 = require("../../../util/array");
const string_1 = require("../../../util/string");
const url_1 = require("../../../util/url");
function extractPackageFile(content, packageFile) {
    logger_1.logger.trace({ packageFile }, 'jsonnet-bundler.extractPackageFile()');
    if (packageFile.includes('vendor/')) {
        return null;
    }
    const deps = [];
    let jsonnetFile;
    try {
        jsonnetFile = JSON.parse(content);
    }
    catch {
        logger_1.logger.debug({ packageFile }, `Invalid JSON`);
        return null;
    }
    for (const dependency of (0, array_1.coerceArray)(jsonnetFile.dependencies)) {
        const dep = extractDependency(dependency);
        if (dep) {
            deps.push(dep);
        }
    }
    if (!deps.length) {
        return null;
    }
    return { deps };
}
function extractDependency(dependency) {
    if (!dependency.source.git) {
        return null;
    }
    const gitRemote = (0, url_1.parseUrl)(dependency.source.git.remote);
    if (!gitRemote) {
        logger_1.logger.debug({ dependency }, 'Invalid Git remote URL');
        return null;
    }
    const depName = (0, upath_1.join)(gitRemote.host, gitRemote.pathname.replace(/\.git$/, ''), (0, string_1.coerceString)(dependency.source.git.subdir));
    return {
        depName,
        packageName: dependency.source.git.remote,
        currentValue: dependency.version,
        managerData: { subdir: dependency.source.git.subdir },
    };
}
//# sourceMappingURL=extract.js.map