"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.allManagersList = exports.getManagers = exports.getManagerList = exports.hashMap = void 0;
exports.get = get;
exports.detectAllGlobalConfig = detectAllGlobalConfig;
exports.extractAllPackageFiles = extractAllPackageFiles;
exports.extractPackageFile = extractPackageFile;
exports.getRangeStrategy = getRangeStrategy;
exports.isKnownManager = isKnownManager;
exports.getEnabledManagersList = getEnabledManagersList;
const tslib_1 = require("tslib");
const api_1 = tslib_1.__importDefault(require("./api"));
const custom_1 = require("./custom");
const api_2 = tslib_1.__importDefault(require("./custom/api"));
var fingerprint_generated_1 = require("./fingerprint.generated");
Object.defineProperty(exports, "hashMap", { enumerable: true, get: function () { return fingerprint_generated_1.hashMap; } });
const managerList = Array.from(api_1.default.keys()); // does not include custom managers
const getManagerList = () => managerList;
exports.getManagerList = getManagerList;
const getManagers = () => api_1.default;
exports.getManagers = getManagers;
exports.allManagersList = [...managerList, ...custom_1.customManagerList];
function get(manager, name) {
    return (0, custom_1.isCustomManager)(manager)
        ? api_2.default.get(manager)?.[name]
        : api_1.default.get(manager)?.[name];
}
async function detectAllGlobalConfig() {
    let config = {};
    for (const managerName of exports.allManagersList) {
        const manager = api_1.default.get(managerName) ?? api_2.default.get(managerName);
        if (manager.detectGlobalConfig) {
            // This should use mergeChildConfig once more than one manager is supported, but introduces a cyclic dependency
            config = { ...config, ...(await manager.detectGlobalConfig()) };
        }
    }
    return config;
}
async function extractAllPackageFiles(manager, config, files) {
    if (!api_1.default.has(manager)) {
        return null;
    }
    const m = api_1.default.get(manager);
    if (m.extractAllPackageFiles) {
        const res = await m.extractAllPackageFiles(config, files);
        // istanbul ignore if
        if (!res) {
            return null;
        }
        return res;
    }
    return null;
}
function extractPackageFile(manager, content, fileName, config) {
    const m = api_1.default.get(manager) ?? api_2.default.get(manager);
    if (!m) {
        return null;
    }
    return m.extractPackageFile
        ? m.extractPackageFile(content, fileName, config)
        : null;
}
function getRangeStrategy(config) {
    const { manager, rangeStrategy } = config;
    if (!manager || !api_1.default.has(manager)) {
        return null;
    }
    const m = api_1.default.get(manager);
    if (m.getRangeStrategy) {
        // Use manager's own function if it exists
        const managerRangeStrategy = m.getRangeStrategy(config);
        if (managerRangeStrategy === 'in-range-only') {
            return 'update-lockfile';
        }
        return managerRangeStrategy;
    }
    if (rangeStrategy === 'auto') {
        if (m.updateLockedDependency) {
            return 'update-lockfile';
        }
        // default to 'replace' for auto
        return 'replace';
    }
    if (rangeStrategy === 'in-range-only') {
        return 'update-lockfile';
    }
    return config.rangeStrategy;
}
function isKnownManager(mgr) {
    return exports.allManagersList.includes(mgr.replace('custom.', ''));
}
/**
 * Filter a list of managers based on enabled managers.
 *
 * If enabledManagers is provided, this function returns a subset of allManagersList
 * that matches the enabled manager names, including custom managers. If enabledManagers
 * is not provided or is an empty array, it returns the full list of managers.
 */
function getEnabledManagersList(enabledManagers) {
    if (enabledManagers?.length) {
        return exports.allManagersList.filter((manager) => enabledManagers.includes(manager) ||
            enabledManagers.includes(`custom.${manager}`));
    }
    return exports.allManagersList;
}
//# sourceMappingURL=index.js.map