import type { RangeStrategy } from '../../types';
import type { ExtractConfig, GlobalManagerConfig, ManagerApi, MaybePromise, PackageFile, PackageFileContent, RangeConfig } from './types';
export { hashMap } from './fingerprint.generated';
export declare const getManagerList: () => string[];
export declare const getManagers: () => Map<string, ManagerApi>;
export declare const allManagersList: string[];
export declare function get<T extends keyof ManagerApi>(manager: string, name: T): ManagerApi[T] | undefined;
export declare function detectAllGlobalConfig(): Promise<GlobalManagerConfig>;
export declare function extractAllPackageFiles(manager: string, config: ExtractConfig, files: string[]): Promise<PackageFile[] | null>;
export declare function extractPackageFile(manager: string, content: string, fileName: string, config: ExtractConfig): MaybePromise<PackageFileContent | null>;
export declare function getRangeStrategy(config: RangeConfig): RangeStrategy | null;
export declare function isKnownManager(mgr: string): boolean;
/**
 * Filter a list of managers based on enabled managers.
 *
 * If enabledManagers is provided, this function returns a subset of allManagersList
 * that matches the enabled manager names, including custom managers. If enabledManagers
 * is not provided or is an empty array, it returns the full list of managers.
 */
export declare function getEnabledManagersList(enabledManagers?: string[]): string[];
