"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateDependency = updateDependency;
const logger_1 = require("../../../logger");
const updateLine = '#hermit updated';
/**
 * updateDependency appends a comment line once.
 * This is only for the purpose of triggering the artifact update
 * Hermit doesn't have a package file to update like other package managers.
 */
function updateDependency({ fileContent, upgrade, }) {
    logger_1.logger.trace({ upgrade }, `hermit.updateDependency()`);
    if (!fileContent.endsWith(updateLine)) {
        logger_1.logger.debug(`append update line to the fileContent if it hasn't been`);
        return `${fileContent}\n${updateLine}`;
    }
    return fileContent;
}
//# sourceMappingURL=update.js.map