import type { HelmRelease, HelmRepository } from './schema';
/** Returns true if a helmfile release contains kustomize specific keys **/
export declare function kustomizationsKeysUsed(release: HelmRelease): boolean;
/** Returns true if a helmfile release uses a local chart with a kustomization.yaml file **/
export declare function localChartHasKustomizationsYaml(release: HelmRelease, helmFileYamlFileName: string): Promise<boolean>;
export declare function isOCIRegistry(repository: HelmRepository): boolean;
export declare function generateRegistryLoginCmd(repositoryName: string, repositoryBaseURL: string, repositoryHost: string): Promise<string | null>;
