"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.categories = exports.defaultConfig = void 0;
exports.extractPackageFile = extractPackageFile;
exports.getRangeStrategy = getRangeStrategy;
const tslib_1 = require("tslib");
const hackage_1 = require("../../datasource/hackage");
const pvpVersioning = tslib_1.__importStar(require("../../versioning/pvp"));
const extract_1 = require("./extract");
exports.defaultConfig = {
    managerFilePatterns: ['/\\.cabal$/'],
    pinDigests: false,
};
exports.categories = ['haskell'];
exports.supportedDatasources = [hackage_1.HackageDatasource.id];
function extractPackageFile(content) {
    const deps = [];
    let current = content;
    for (;;) {
        const maybeContent = (0, extract_1.findDepends)(current);
        if (maybeContent === null) {
            break;
        }
        const cabalDeps = (0, extract_1.extractNamesAndRanges)(maybeContent.buildDependsContent);
        for (const cabalDep of cabalDeps) {
            const dep = {
                depName: cabalDep.packageName,
                currentValue: cabalDep.currentValue,
                datasource: hackage_1.HackageDatasource.id,
                packageName: cabalDep.packageName,
                versioning: pvpVersioning.id,
                replaceString: cabalDep.replaceString.trim(),
                autoReplaceStringTemplate: '{{{depName}}} {{{newValue}}}',
            };
            deps.push(dep);
        }
        current = current.slice(maybeContent.lengthProcessed);
    }
    return { deps };
}
function getRangeStrategy({ rangeStrategy, }) {
    if (rangeStrategy === 'auto') {
        return 'widen';
    }
    return rangeStrategy;
}
//# sourceMappingURL=index.js.map