import type { PackageDependency } from '../types';
import type { GradleManagerData, PackageVariables, VariableRegistry } from './types';
export declare function versionLikeSubstring(input: string | null | undefined): string | null;
export declare function isDependencyString(input: string): boolean;
export declare function parseDependencyString(input: string): PackageDependency<GradleManagerData> | null;
export declare function isGradleScriptFile(path: string): boolean;
export declare function isGradleVersionsFile(path: string): boolean;
export declare function isGradleBuildFile(path: string): boolean;
export declare function isPropsFile(path: string): boolean;
export declare function isKotlinSourceFile(path: string): boolean;
export declare function isTOMLFile(path: string): boolean;
export declare function toAbsolutePath(packageFile: string): string;
export declare function reorderFiles(packageFiles: string[]): string[];
export declare function getVars(registry: VariableRegistry, dir: string, vars?: PackageVariables): PackageVariables;
export declare function updateVars(registry: VariableRegistry, dir: string, newVars: PackageVariables): void;
