"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.qKotlinMultiObjectVarAssignment = void 0;
const good_enough_parser_1 = require("good-enough-parser");
const assignments_1 = require("./assignments");
const common_1 = require("./common");
const dependencies_1 = require("./dependencies");
const handlers_1 = require("./handlers");
const qKotlinListOfAssignment = good_enough_parser_1.query.sym('listOf').tree({
    type: 'wrapped-tree',
    startsWith: '(',
    endsWith: ')',
    search: dependencies_1.qDependencyStrings,
});
const qKotlinSingleObjectVarAssignment = good_enough_parser_1.query.alt(
// val dep = mapOf("qux" to "foo:bar:\${Versions.baz}")
assignments_1.qKotlinMultiMapOfVarAssignment, common_1.qVariableAssignmentIdentifier
    .opt(good_enough_parser_1.query.op(':').sym('String'))
    .op('=')
    .handler(common_1.prependNestingDepth)
    .handler(common_1.coalesceVariable)
    .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'keyToken'))
    .alt(
// val deps = listOf("androidx.appcompat:appcompat:$baz", listOf("androidx.webkit:webkit:${Versions.baz}"))
qKotlinListOfAssignment, 
// val dep: String = "foo:bar:" + Versions.baz
common_1.qValueMatcher
    .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'valToken'))
    .handler(handlers_1.handleAssignment))
    .handler(common_1.cleanupTempVars));
// object foo { ... }
const qKotlinMultiObjectExpr = (search) => good_enough_parser_1.query.alt(good_enough_parser_1.query.sym('object').sym(common_1.storeVarToken).tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    startsWith: '{',
    endsWith: '}',
    preHandler: common_1.increaseNestingDepth,
    search,
    postHandler: common_1.reduceNestingDepth,
}), qKotlinSingleObjectVarAssignment);
exports.qKotlinMultiObjectVarAssignment = qKotlinMultiObjectExpr(qKotlinMultiObjectExpr(qKotlinMultiObjectExpr(qKotlinMultiObjectExpr(qKotlinSingleObjectVarAssignment)))).handler(common_1.cleanupTempVars);
//# sourceMappingURL=objects.js.map