"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.qDependencies = exports.qLongFormDep = exports.qGroovyMapNotationDependencies = exports.qDependencyStrings = void 0;
const good_enough_parser_1 = require("good-enough-parser");
const regex_1 = require("../../../../util/regex");
const common_1 = require("./common");
const handlers_1 = require("./handlers");
// "foo:bar:1.2.3"
// "foo:bar:$baz"
// "foo" + "${bar}" + baz
exports.qDependencyStrings = common_1.qTemplateString
    .opt(good_enough_parser_1.query.op('+').join(common_1.qValueMatcher))
    .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'templateStringTokens'))
    .handler(handlers_1.handleDepString)
    .handler(common_1.cleanupTempVars);
// dependencySet(group: 'foo', version: bar) { entry 'baz' }
const qDependencySet = good_enough_parser_1.query
    .sym('dependencySet', common_1.storeVarToken)
    .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'methodName'))
    .tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    startsWith: '(',
    endsWith: ')',
    search: good_enough_parser_1.query
        .begin()
        .sym('group')
        .alt(good_enough_parser_1.query.op(':'), good_enough_parser_1.query.op('='))
        .join(common_1.qGroupId)
        .op(',')
        .sym('version')
        .alt(good_enough_parser_1.query.op(':'), good_enough_parser_1.query.op('='))
        .join(common_1.qVersion)
        .end(),
})
    .tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    startsWith: '{',
    endsWith: '}',
    search: good_enough_parser_1.query
        .sym('entry')
        .alt(common_1.qArtifactId, good_enough_parser_1.query.tree({
        type: 'wrapped-tree',
        maxDepth: 1,
        startsWith: '(',
        endsWith: ')',
        search: good_enough_parser_1.query.begin().join(common_1.qArtifactId).end(),
    }))
        .handler(handlers_1.handleLongFormDep),
})
    .handler(common_1.cleanupTempVars);
// group: "foo", name: "bar", version: "1.2.3"
exports.qGroovyMapNotationDependencies = good_enough_parser_1.query
    .sym('group')
    .op(':')
    .join(common_1.qGroupId)
    .op(',')
    .sym('name')
    .op(':')
    .join(common_1.qArtifactId)
    .op(',')
    .sym('version')
    .op(':')
    .join(common_1.qVersion)
    .handler(handlers_1.handleLongFormDep)
    .handler(common_1.cleanupTempVars);
// kotlin("bom", "1.7.21")
const qKotlinShortNotationDependencies = good_enough_parser_1.query
    .sym('kotlin')
    .tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    startsWith: '(',
    endsWith: ')',
    search: good_enough_parser_1.query
        .begin()
        .join(common_1.qArtifactId)
        .op(',')
        .opt(good_enough_parser_1.query.sym('version').op('='))
        .join(common_1.qVersion)
        .end(),
})
    .handler(handlers_1.handleKotlinShortNotationDep)
    .handler(common_1.cleanupTempVars);
// (group = "foo", name = "bar", version = "1.2.3")
const qKotlinMapNotationDependencies = good_enough_parser_1.query
    .tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    startsWith: '(',
    endsWith: ')',
    search: good_enough_parser_1.query
        .begin()
        .sym('group')
        .op('=')
        .join(common_1.qGroupId)
        .op(',')
        .sym('name')
        .op('=')
        .join(common_1.qArtifactId)
        .op(',')
        .sym('version')
        .op('=')
        .join(common_1.qVersion),
})
    .handler(handlers_1.handleLongFormDep)
    .handler(common_1.cleanupTempVars);
// someMethod("foo", "bar", "1.2.3")
exports.qLongFormDep = good_enough_parser_1.query
    .opt(good_enough_parser_1.query.sym(common_1.storeVarToken).handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'methodName')))
    .tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    maxMatches: 1,
    startsWith: '(',
    endsWith: ')',
    search: good_enough_parser_1.query
        .begin()
        .join(common_1.qGroupId)
        .op(',')
        .join(common_1.qArtifactId)
        .op(',')
        .join(common_1.qVersion)
        .end(),
})
    .handler(handlers_1.handleLongFormDep)
    .handler(common_1.cleanupTempVars);
// pmd { toolVersion = "1.2.3" }
const qImplicitGradlePlugin = good_enough_parser_1.query
    .alt(...Object.keys(common_1.GRADLE_PLUGINS).map((implicitDepName) => good_enough_parser_1.query
    .sym(implicitDepName, common_1.storeVarToken)
    .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'implicitDepName'))
    .tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    maxMatches: 1,
    startsWith: '{',
    endsWith: '}',
    search: good_enough_parser_1.query
        .sym(common_1.GRADLE_PLUGINS[implicitDepName][0])
        .alt(
    // toolVersion = "1.2.3"
    good_enough_parser_1.query.opt(good_enough_parser_1.query.op('=')).join(common_1.qVersion), 
    // toolVersion.set("1.2.3"), toolVersion.value("1.2.3")
    good_enough_parser_1.query
        .op('.')
        .sym((0, regex_1.regEx)(/^(?:set|value)$/))
        .tree({
        maxDepth: 1,
        startsWith: '(',
        endsWith: ')',
        search: good_enough_parser_1.query.begin().join(common_1.qVersion).end(),
    })),
})))
    .handler(handlers_1.handleImplicitDep)
    .handler(common_1.cleanupTempVars);
// testing { suites { test { useSpock("1.2.3") } } }
const qImplicitTestSuites = (0, common_1.qDotOrBraceExpr)('testing', (0, common_1.qDotOrBraceExpr)('suites', (0, common_1.qDotOrBraceExpr)('test', good_enough_parser_1.query
    .sym((0, regex_1.regEx)(`^(?:${Object.keys(common_1.GRADLE_TEST_SUITES).join('|')})$`), common_1.storeVarToken)
    .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'implicitDepName'))
    .tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    maxMatches: 1,
    startsWith: '(',
    endsWith: ')',
    search: good_enough_parser_1.query.begin().join(common_1.qVersion).end(),
}))))
    .handler(handlers_1.handleImplicitDep)
    .handler(common_1.cleanupTempVars);
exports.qDependencies = good_enough_parser_1.query.alt(exports.qDependencyStrings, qDependencySet, exports.qGroovyMapNotationDependencies, qKotlinShortNotationDependencies, qKotlinMapNotationDependencies, qImplicitGradlePlugin, qImplicitTestSuites, 
// avoid heuristic matching of gradle feature variant capabilities
(0, common_1.qDotOrBraceExpr)('java', good_enough_parser_1.query.sym('registerFeature').tree()));
//# sourceMappingURL=dependencies.js.map