"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.qVersion = exports.qArtifactId = exports.qGroupId = exports.qDotOrBraceExpr = exports.qKotlinImport = exports.qValueMatcher = exports.qConcatExpr = exports.qTemplateString = exports.qPropertyAccessIdentifier = exports.qVariableAccessIdentifier = exports.qVariableAssignmentIdentifier = exports.qStringValueAsSymbol = exports.qStringValue = exports.GRADLE_TEST_SUITES = exports.GRADLE_PLUGINS = exports.REGISTRY_URLS = void 0;
exports.storeVarToken = storeVarToken;
exports.increaseNestingDepth = increaseNestingDepth;
exports.reduceNestingDepth = reduceNestingDepth;
exports.prependNestingDepth = prependNestingDepth;
exports.storeInTokenMap = storeInTokenMap;
exports.loadFromTokenMap = loadFromTokenMap;
exports.cleanupTempVars = cleanupTempVars;
exports.stripReservedPrefixFromKeyTokens = stripReservedPrefixFromKeyTokens;
exports.coalesceVariable = coalesceVariable;
exports.findVariableInKotlinImport = findVariableInKotlinImport;
exports.findVariable = findVariable;
exports.interpolateString = interpolateString;
const good_enough_parser_1 = require("good-enough-parser");
const clone_1 = require("../../../../util/clone");
const regex_1 = require("../../../../util/regex");
exports.REGISTRY_URLS = {
    google: 'https://dl.google.com/android/maven2/',
    gradlePluginPortal: 'https://plugins.gradle.org/m2/',
    jcenter: 'https://jcenter.bintray.com/',
    mavenCentral: 'https://repo.maven.apache.org/maven2',
};
exports.GRADLE_PLUGINS = {
    checkstyle: ['toolVersion', 'com.puppycrawl.tools:checkstyle'],
    codenarc: ['toolVersion', 'org.codenarc:CodeNarc'],
    composeOptions: [
        'kotlinCompilerExtensionVersion',
        'androidx.compose.compiler:compiler',
    ],
    detekt: ['toolVersion', 'io.gitlab.arturbosch.detekt:detekt-core'],
    findbugs: ['toolVersion', 'com.google.code.findbugs:findbugs'],
    googleJavaFormat: [
        'toolVersion',
        'com.google.googlejavaformat:google-java-format',
    ],
    jacoco: ['toolVersion', 'org.jacoco:jacoco'],
    jmh: ['jmhVersion', 'org.openjdk.jmh:jmh-core'],
    lombok: ['version', 'org.projectlombok:lombok'],
    micronaut: ['version', 'io.micronaut.platform:micronaut-platform'],
    pmd: ['toolVersion', 'net.sourceforge.pmd:pmd-java'],
    spotbugs: ['toolVersion', 'com.github.spotbugs:spotbugs'],
};
exports.GRADLE_TEST_SUITES = {
    useJunit: 'junit:junit',
    useJUnitJupiter: 'org.junit.jupiter:junit-jupiter',
    useKotlinTest: 'org.jetbrains.kotlin:kotlin-test-junit',
    useSpock: 'org.spockframework:spock-core',
    useTestNG: 'org.testng:testng',
};
function storeVarToken(ctx, node) {
    ctx.varTokens.push(node);
    return ctx;
}
function increaseNestingDepth(ctx) {
    ctx.tmpNestingDepth.push(...ctx.varTokens);
    ctx.varTokens = [];
    return ctx;
}
function reduceNestingDepth(ctx) {
    ctx.tmpNestingDepth.pop();
    return ctx;
}
function prependNestingDepth(ctx) {
    ctx.varTokens = [...(0, clone_1.clone)(ctx.tmpNestingDepth), ...ctx.varTokens];
    return ctx;
}
function storeInTokenMap(ctx, tokenMapKey) {
    ctx.tokenMap[tokenMapKey] = ctx.varTokens;
    ctx.varTokens = [];
    return ctx;
}
function loadFromTokenMap(ctx, tokenMapKey) {
    const tokens = ctx.tokenMap[tokenMapKey];
    if (!tokens) {
        throw new Error(`Expected token ${tokenMapKey} not found`);
    }
    return tokens;
}
function cleanupTempVars(ctx) {
    ctx.tokenMap = {};
    ctx.varTokens = [];
    return ctx;
}
function stripReservedPrefixFromKeyTokens(ctx) {
    const unwantedPrefixes = [
        'ext',
        'extra',
        'project',
        'rootProject',
        'properties',
    ];
    while (ctx.varTokens.length > 1 && // ensures there will be always at least one token
        ctx.varTokens[0] &&
        unwantedPrefixes.includes(ctx.varTokens[0].value)) {
        ctx.varTokens.shift();
    }
    return ctx;
}
function coalesceVariable(ctx) {
    if (ctx.varTokens.length > 1) {
        ctx.varTokens[0].value = ctx.varTokens
            .map((token) => token.value)
            .join('.');
        ctx.varTokens.length = 1;
    }
    return ctx;
}
function findVariableInKotlinImport(name, ctx, variables) {
    if (ctx.tmpKotlinImportStore.length && name.includes('.')) {
        for (const tokens of ctx.tmpKotlinImportStore) {
            const lastToken = tokens[tokens.length - 1];
            if (lastToken && name.startsWith(`${lastToken.value}.`)) {
                const prefix = tokens
                    .slice(0, -1)
                    .map((token) => token.value)
                    .join('.');
                const identifier = `${prefix}.${name}`;
                if (variables[identifier]) {
                    return variables[identifier];
                }
            }
        }
    }
    return undefined;
}
function findVariable(name, ctx, variables = ctx.globalVars) {
    if (ctx.tmpNestingDepth.length) {
        const prefixParts = ctx.tmpNestingDepth.map((token) => token.value);
        for (let idx = ctx.tmpNestingDepth.length; idx > 0; idx -= 1) {
            const prefix = prefixParts.slice(0, idx).join('.');
            const identifier = `${prefix}.${name}`;
            if (variables[identifier]) {
                return variables[identifier];
            }
        }
    }
    if (variables[name]) {
        return variables[name];
    }
    return findVariableInKotlinImport(name, ctx, variables);
}
function interpolateString(childTokens, ctx, variables = ctx.globalVars) {
    const resolvedSubstrings = [];
    for (const childToken of childTokens) {
        const type = childToken.type;
        if (type === 'string-value') {
            resolvedSubstrings.push(childToken.value);
        }
        else if (type === 'symbol') {
            const varData = findVariable(childToken.value, ctx, variables);
            if (varData) {
                resolvedSubstrings.push(varData.value);
            }
            else {
                return null;
            }
        }
        else {
            return null;
        }
    }
    return resolvedSubstrings.join('');
}
exports.qStringValue = good_enough_parser_1.query.str((ctx, node) => {
    storeVarToken(ctx, node);
    return ctx;
});
exports.qStringValueAsSymbol = good_enough_parser_1.query.str((ctx, node) => {
    const nodeTransformed = {
        ...node,
        type: 'symbol',
    };
    storeVarToken(ctx, nodeTransformed);
    return ctx;
});
// foo.bar["baz"] = "1.2.3"
exports.qVariableAssignmentIdentifier = good_enough_parser_1.query
    .sym(storeVarToken)
    .many(good_enough_parser_1.query.alt(good_enough_parser_1.query.op('.').sym(storeVarToken), good_enough_parser_1.query.tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    startsWith: '[',
    endsWith: ']',
    search: good_enough_parser_1.query.begin().join(exports.qStringValueAsSymbol).end(),
})), 0, 32)
    .handler(stripReservedPrefixFromKeyTokens);
// foo.bar["baz"] -> "foo.bar.baz"
exports.qVariableAccessIdentifier = good_enough_parser_1.query
    .handler((ctx) => {
    ctx.tmpTokenStore.backupVarAccessTokens = ctx.varTokens;
    ctx.varTokens = [];
    return ctx;
})
    .join(exports.qVariableAssignmentIdentifier)
    .handler(coalesceVariable)
    .handler((ctx) => {
    ctx.varTokens = [
        ...ctx.tmpTokenStore.backupVarAccessTokens,
        ...ctx.varTokens,
    ];
    delete ctx.tmpTokenStore.backupVarAccessTokens;
    return ctx;
});
// project.ext.getProperty(...)
// extra.get(...)
exports.qPropertyAccessIdentifier = good_enough_parser_1.query
    .opt(good_enough_parser_1.query.sym((0, regex_1.regEx)(/^(?:rootProject|project)$/)).op('.'))
    .alt(good_enough_parser_1.query.opt(good_enough_parser_1.query.sym('ext').op('.')).sym((0, regex_1.regEx)(/^(?:property|getProperty)$/)), good_enough_parser_1.query
    .sym((0, regex_1.regEx)(/^(?:extra|ext)$/))
    .op('.')
    .sym('get'))
    .tree({
    maxDepth: 1,
    startsWith: '(',
    endsWith: ')',
    search: good_enough_parser_1.query.begin().join(exports.qStringValueAsSymbol).end(),
})
    .opt(good_enough_parser_1.query.sym('as').sym('String'));
// "foo${bar}baz"
exports.qTemplateString = good_enough_parser_1.query
    .tree({
    type: 'string-tree',
    maxDepth: 2,
    preHandler: (ctx) => {
        ctx.tmpTokenStore.templateTokens = [];
        return ctx;
    },
    search: good_enough_parser_1.query
        .alt(exports.qStringValue, exports.qPropertyAccessIdentifier, exports.qVariableAccessIdentifier)
        .handler((ctx) => {
        ctx.tmpTokenStore.templateTokens?.push(...ctx.varTokens);
        ctx.varTokens = [];
        return ctx;
    }),
})
    .handler((ctx) => {
    ctx.varTokens = ctx.tmpTokenStore.templateTokens;
    return ctx;
});
// foo = "bar"
// foo + foo + "${foo}" + "foo" => "barbarbarfoo"
const qConcatExpr = (...matchers) => good_enough_parser_1.query.alt(...matchers).many(good_enough_parser_1.query.op('+').alt(...matchers), 0, 32);
exports.qConcatExpr = qConcatExpr;
exports.qValueMatcher = (0, exports.qConcatExpr)(exports.qTemplateString, exports.qPropertyAccessIdentifier, exports.qVariableAccessIdentifier);
// import foo.bar
// runtimeOnly("some:foo:${bar.bazVersion}")
exports.qKotlinImport = good_enough_parser_1.query
    .sym('import')
    .join(exports.qVariableAssignmentIdentifier)
    .handler((ctx) => {
    ctx.tmpKotlinImportStore.push(ctx.varTokens);
    return ctx;
})
    .handler(cleanupTempVars);
// foo { bar { baz } }
// foo.bar { baz }
const qDotOrBraceExpr = (symValue, matcher) => good_enough_parser_1.query.sym(symValue).alt(good_enough_parser_1.query.op('.').join(matcher), good_enough_parser_1.query.tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    startsWith: '{',
    endsWith: '}',
    search: matcher,
}));
exports.qDotOrBraceExpr = qDotOrBraceExpr;
exports.qGroupId = exports.qValueMatcher.handler((ctx) => storeInTokenMap(ctx, 'groupId'));
exports.qArtifactId = exports.qValueMatcher.handler((ctx) => storeInTokenMap(ctx, 'artifactId'));
exports.qVersion = exports.qValueMatcher.handler((ctx) => storeInTokenMap(ctx, 'version'));
//# sourceMappingURL=common.js.map