"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.qAssignments = exports.qKotlinMultiMapOfVarAssignment = void 0;
const good_enough_parser_1 = require("good-enough-parser");
const regex_1 = require("../../../../util/regex");
const common_1 = require("./common");
const dependencies_1 = require("./dependencies");
const handlers_1 = require("./handlers");
// foo = "1.2.3"
const qGroovySingleVarAssignment = common_1.qVariableAssignmentIdentifier
    .op('=')
    .handler(common_1.coalesceVariable)
    .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'keyToken'))
    .join(common_1.qStringValue)
    .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'valToken'))
    .handler(handlers_1.handleAssignment)
    .handler(common_1.cleanupTempVars);
// set("foo", "1.2.3")
const qKotlinSingleVarAssignment = good_enough_parser_1.query
    .sym((0, regex_1.regEx)(/^(?:set|version)$/))
    .tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    startsWith: '(',
    endsWith: ')',
    search: good_enough_parser_1.query
        .begin()
        .join(common_1.qStringValue)
        .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'keyToken'))
        .op(',')
        .join(common_1.qStringValue)
        .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'valToken'))
        .handler(handlers_1.handleAssignment)
        .end(),
})
    .handler(common_1.cleanupTempVars);
// val foo by extra { "1.2.3" }
const qKotlinSingleExtraVarAssignment = good_enough_parser_1.query
    .sym('val')
    .sym(common_1.storeVarToken)
    .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'keyToken'))
    .opt(good_enough_parser_1.query.op(':').sym('String'))
    .sym('by')
    .sym('extra')
    .tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    search: good_enough_parser_1.query
        .begin()
        .join(common_1.qStringValue)
        .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'valToken'))
        .handler(handlers_1.handleAssignment)
        .end(),
})
    .handler(common_1.cleanupTempVars);
const qGroovySingleMapOfVarAssignment = good_enough_parser_1.query.alt(
// foo: [group: "foo", name: "bar", version: "1.2.3"]
good_enough_parser_1.query.begin().join(dependencies_1.qGroovyMapNotationDependencies).end(), 
// foo: "1.2.3"
good_enough_parser_1.query
    .alt(good_enough_parser_1.query.sym(common_1.storeVarToken), good_enough_parser_1.query.str(common_1.storeVarToken))
    .handler(common_1.prependNestingDepth)
    .handler(common_1.coalesceVariable)
    .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'keyToken'))
    .op(':')
    .join(common_1.qValueMatcher)
    .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'valToken'))
    .handler(handlers_1.handleAssignment), 
// ["foo:bar:1.2.3", "foo:baz:$qux"]
dependencies_1.qDependencyStrings);
const qGroovyMapOfExpr = (search) => good_enough_parser_1.query.alt(good_enough_parser_1.query.alt(good_enough_parser_1.query.sym(common_1.storeVarToken), good_enough_parser_1.query.str(common_1.storeVarToken)).op(':').tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    startsWith: '[',
    endsWith: ']',
    preHandler: common_1.increaseNestingDepth,
    search,
    postHandler: common_1.reduceNestingDepth,
}), qGroovySingleMapOfVarAssignment);
// versions = [ android: [ buildTools: '30.0.3' ], kotlin: '1.4.30' ]
const qGroovyMultiVarAssignment = common_1.qVariableAssignmentIdentifier
    .alt(good_enough_parser_1.query.op('='), good_enough_parser_1.query.op('+='))
    .tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    startsWith: '[',
    endsWith: ']',
    preHandler: common_1.increaseNestingDepth,
    search: qGroovyMapOfExpr(qGroovyMapOfExpr(qGroovySingleMapOfVarAssignment)),
    postHandler: common_1.reduceNestingDepth,
})
    .handler(common_1.cleanupTempVars);
// "foo1" to "bar1"
const qKotlinSingleMapOfVarAssignment = common_1.qStringValue
    .sym('to')
    .handler(common_1.prependNestingDepth)
    .handler(common_1.coalesceVariable)
    .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'keyToken'))
    .join(common_1.qValueMatcher)
    .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'valToken'))
    .handler(handlers_1.handleAssignment);
const qKotlinMapOfExpr = (search) => good_enough_parser_1.query.alt(common_1.qStringValue.sym('to').sym('mapOf').tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    startsWith: '(',
    endsWith: ')',
    preHandler: common_1.increaseNestingDepth,
    search,
    postHandler: common_1.reduceNestingDepth,
}), qKotlinSingleMapOfVarAssignment);
// val versions = mapOf("foo1" to "bar1", "foo2" to "bar2", "foo3" to "bar3")
exports.qKotlinMultiMapOfVarAssignment = common_1.qVariableAssignmentIdentifier
    .op('=')
    .sym('mapOf')
    .tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    startsWith: '(',
    endsWith: ')',
    preHandler: common_1.increaseNestingDepth,
    search: qKotlinMapOfExpr(qKotlinMapOfExpr(qKotlinSingleMapOfVarAssignment)),
    postHandler: common_1.reduceNestingDepth,
})
    .handler(common_1.cleanupTempVars);
exports.qAssignments = good_enough_parser_1.query.alt(qGroovySingleVarAssignment, qGroovyMultiVarAssignment, qKotlinSingleVarAssignment, qKotlinSingleExtraVarAssignment, exports.qKotlinMultiMapOfVarAssignment);
//# sourceMappingURL=assignments.js.map