"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.qApplyFrom = void 0;
const good_enough_parser_1 = require("good-enough-parser");
const regex_1 = require("../../../../util/regex");
const common_1 = require("./common");
const handlers_1 = require("./handlers");
// apply from: 'foo.gradle'
// apply(from = property("foo"))
const qApplyFromFile = good_enough_parser_1.query
    .alt(good_enough_parser_1.query
    .alt(good_enough_parser_1.query
    .opt(good_enough_parser_1.query.sym((0, regex_1.regEx)(/^(?:rootProject|project)$/)).op('.'))
    .sym('file'), good_enough_parser_1.query.opt(good_enough_parser_1.query.sym('new')).sym('File'))
    .tree({
    maxDepth: 1,
    startsWith: '(',
    endsWith: ')',
    search: good_enough_parser_1.query
        .begin()
        .opt(good_enough_parser_1.query
        .join(common_1.qValueMatcher, good_enough_parser_1.query.op(','))
        .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'parentPath')))
        .join(common_1.qValueMatcher)
        .end(),
}), common_1.qValueMatcher)
    .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'scriptFile'));
exports.qApplyFrom = good_enough_parser_1.query
    .sym('apply')
    .alt(good_enough_parser_1.query // apply from: rootProject.file("basedir", "foo/bar.gradle")
    .sym('from')
    .op(':')
    .join(qApplyFromFile), good_enough_parser_1.query // apply(from = File(base, "bar.gradle"))
    .tree({
    maxDepth: 1,
    maxMatches: 1,
    startsWith: '(',
    endsWith: ')',
    search: good_enough_parser_1.query.begin().sym('from').op('=').join(qApplyFromFile).end(),
}))
    .handler(handlers_1.handleApplyFrom)
    .handler(common_1.cleanupTempVars);
//# sourceMappingURL=apply-from.js.map