import type { PackageDependency } from '../types';
import type { GradleManagerData, PackageVariables, ParseGradleResult } from './types';
export declare function parseGradle(input: string, initVars?: PackageVariables, packageFile?: string, fileContents?: Record<string, string | null>, recursionDepth?: number): ParseGradleResult;
export declare function parseKotlinSource(input: string, initVars?: PackageVariables, packageFile?: string): {
    vars: PackageVariables;
    deps: PackageDependency<GradleManagerData>[];
};
export declare function parseJavaToolchainVersion(input: string): string | null;
export declare function parseProps(input: string, packageFile?: string): {
    vars: PackageVariables;
    deps: PackageDependency<GradleManagerData>[];
};
