"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.supportsLockFileMaintenance = exports.updateArtifacts = exports.updateDependency = exports.extractAllPackageFiles = void 0;
const tslib_1 = require("tslib");
const maven_1 = require("../../datasource/maven");
const gradleVersioning = tslib_1.__importStar(require("../../versioning/gradle"));
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractAllPackageFiles", { enumerable: true, get: function () { return extract_1.extractAllPackageFiles; } });
var update_1 = require("./update");
Object.defineProperty(exports, "updateDependency", { enumerable: true, get: function () { return update_1.updateDependency; } });
var artifacts_1 = require("./artifacts");
Object.defineProperty(exports, "updateArtifacts", { enumerable: true, get: function () { return artifacts_1.updateArtifacts; } });
exports.supportsLockFileMaintenance = true;
exports.url = 'https://docs.gradle.org/current/userguide/getting_started_dep_man.html';
exports.categories = ['java'];
exports.defaultConfig = {
    managerFilePatterns: [
        '/\\.gradle(\\.kts)?$/',
        '/(^|/)gradle\\.properties$/',
        '/(^|/)gradle/.+\\.toml$/',
        '/(^|/)buildSrc/.+\\.kt$/',
        '/\\.versions\\.toml$/',
        // The two below is for gradle-consistent-versions plugin
        `/(^|/)versions.props$/`,
        `/(^|/)versions.lock$/`,
    ],
    timeout: 600,
    versioning: gradleVersioning.id,
};
exports.supportedDatasources = [maven_1.MavenDatasource.id];
//# sourceMappingURL=index.js.map