import type { GradleVersionExtract } from './types';
export declare const extraEnv: {
    GRADLE_OPTS: string;
};
export declare function gradleWrapperFileName(): string;
export declare function prepareGradleCommand(gradlewFile: string): Promise<string | null>;
/**
 * Find compatible java version for gradle.
 * see https://docs.gradle.org/current/userguide/compatibility.html
 * @param gradleVersion current gradle version
 * @param gradlewFile path to gradle wrapper
 * @returns A Java semver range
 */
export declare function getJavaConstraint(gradleVersion: string | null | undefined, gradlewFile: string): Promise<string>;
/**
 * https://docs.gradle.org/current/userguide/gradle_daemon.html#sec:daemon_jvm_criteria
 */
export declare function getJvmConfiguration(gradlewFile: string): Promise<string | null>;
/**
 * https://docs.gradle.org/current/userguide/toolchains.html#sec:consuming
 */
export declare function getJavaLanguageVersion(gradlewFile: string): Promise<string | null>;
export declare function extractGradleVersion(fileContent: string): GradleVersionExtract | null;
