"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.displayName = exports.updateArtifacts = exports.updateDependency = exports.extractPackageFile = void 0;
const go_1 = require("../../datasource/go");
const golang_version_1 = require("../../datasource/golang-version");
const artifacts_1 = require("./artifacts");
Object.defineProperty(exports, "updateArtifacts", { enumerable: true, get: function () { return artifacts_1.updateArtifacts; } });
const extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
const update_1 = require("./update");
Object.defineProperty(exports, "updateDependency", { enumerable: true, get: function () { return update_1.updateDependency; } });
exports.displayName = 'Go Modules';
exports.url = 'https://go.dev/ref/mod';
exports.categories = ['golang'];
exports.defaultConfig = {
    managerFilePatterns: ['/(^|/)go\\.mod$/'],
    pinDigests: false,
};
exports.supportedDatasources = [
    go_1.GoDatasource.id,
    golang_version_1.GolangVersionDatasource.id,
];
//# sourceMappingURL=index.js.map