"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const regex_1 = require("../../../util/regex");
const line_parser_1 = require("./line-parser");
function findMatchingModule(tool, deps) {
    let bestMatch;
    const normalizedTool = tool.depName + '/';
    // Find the longest matching prefix for the tool within the dependencies
    for (const dep of deps) {
        if (normalizedTool.startsWith(dep.depName + '/') &&
            dep.depName.length > (bestMatch?.depName.length ?? 0)) {
            bestMatch = dep;
        }
    }
    return bestMatch;
}
function extractPackageFile(content) {
    const deps = [];
    const tools = [];
    let inExcludeBlock = false;
    const lines = content.split(regex_1.newlineRegex);
    for (let lineNumber = 0; lineNumber < lines.length; lineNumber += 1) {
        const line = lines[lineNumber];
        const dep = (0, line_parser_1.parseLine)(line);
        if (inExcludeBlock) {
            if (line_parser_1.endBlockRegex.test(line)) {
                inExcludeBlock = false;
            }
            continue;
        }
        if (!dep) {
            if (line_parser_1.excludeBlockStartRegex.test(line)) {
                inExcludeBlock = true;
            }
            continue;
        }
        if (dep.depType === 'tool') {
            tools.push(dep);
            continue;
        }
        dep.managerData ??= {};
        dep.managerData.lineNumber = lineNumber;
        deps.push(dep);
    }
    for (const tool of tools) {
        const match = findMatchingModule(tool, deps);
        if (match?.depType === 'indirect') {
            delete match.enabled;
        }
    }
    if (!deps.length) {
        return null;
    }
    return { deps };
}
//# sourceMappingURL=extract.js.map