"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManifestToml = exports.GleamToml = void 0;
const zod_1 = require("zod");
const schema_utils_1 = require("../../../util/schema-utils");
exports.GleamToml = schema_utils_1.Toml.pipe(zod_1.z.object({
    name: zod_1.z.string(),
    dependencies: zod_1.z.record(zod_1.z.string(), zod_1.z.string()).optional(),
    ['dev-dependencies']: zod_1.z.record(zod_1.z.string(), zod_1.z.string()).optional(),
}));
const Package = zod_1.z.object({
    name: zod_1.z.string(),
    version: zod_1.z.string(),
    requirements: zod_1.z.array(zod_1.z.string()).optional(),
});
exports.ManifestToml = schema_utils_1.Toml.pipe(zod_1.z.object({
    packages: zod_1.z.array(Package).optional(),
}));
//# sourceMappingURL=schema.js.map