"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getRangeStrategy = getRangeStrategy;
const semver_utils_1 = require("semver-utils");
const logger_1 = require("../../../logger");
function getRangeStrategy(config) {
    const { currentValue, rangeStrategy } = config;
    const isComplexRange = currentValue
        ? (0, semver_utils_1.parseRange)(currentValue).length > 1
        : false;
    if (rangeStrategy === 'bump' && isComplexRange) {
        logger_1.logger.debug({ currentValue }, 'Replacing bump strategy for complex range with widen');
        return 'widen';
    }
    if (rangeStrategy !== 'auto') {
        return rangeStrategy;
    }
    return 'widen';
}
//# sourceMappingURL=range.js.map