"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlasskubeResource = exports.PackageRepository = exports.Package = void 0;
const zod_1 = require("zod");
exports.Package = zod_1.z.object({
    apiVersion: zod_1.z.string().startsWith('packages.glasskube.dev/'),
    kind: zod_1.z.literal('Package').or(zod_1.z.literal('ClusterPackage')),
    spec: zod_1.z.object({
        packageInfo: zod_1.z.object({
            name: zod_1.z.string(),
            version: zod_1.z.string(),
            repositoryName: zod_1.z.string().optional(),
        }),
    }),
});
exports.PackageRepository = zod_1.z.object({
    apiVersion: zod_1.z.string().startsWith('packages.glasskube.dev/'),
    kind: zod_1.z.literal('PackageRepository'),
    metadata: zod_1.z.object({
        name: zod_1.z.string(),
        annotations: zod_1.z.record(zod_1.z.string(), zod_1.z.string()).optional(),
    }),
    spec: zod_1.z.object({
        url: zod_1.z.string(),
    }),
});
exports.GlasskubeResource = exports.Package.or(exports.PackageRepository);
//# sourceMappingURL=schema.js.map