"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.displayName = exports.extractPackageFile = exports.extractAllPackageFiles = void 0;
const docker_1 = require("../../datasource/docker");
const gitlab_tags_1 = require("../../datasource/gitlab-tags");
const extract_1 = require("./extract");
Object.defineProperty(exports, "extractAllPackageFiles", { enumerable: true, get: function () { return extract_1.extractAllPackageFiles; } });
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
exports.displayName = 'GitLab CI/CD';
exports.url = 'https://docs.gitlab.com/ee/ci';
exports.categories = ['ci'];
exports.defaultConfig = {
    managerFilePatterns: ['/\\.gitlab-ci\\.ya?ml$/'],
};
exports.supportedDatasources = [
    docker_1.DockerDatasource.id,
    gitlab_tags_1.GitlabTagsDatasource.id,
];
//# sourceMappingURL=index.js.map