"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitlabDocumentArray = exports.GitlabDocument = void 0;
const zod_1 = require("zod");
const array_1 = require("../../../util/array");
const schema_utils_1 = require("../../../util/schema-utils");
const gitlab_tags_1 = require("../../datasource/gitlab-tags");
const GitlabInclude = zod_1.z
    .object({
    project: zod_1.z.string(),
    ref: zod_1.z.string().optional().catch(undefined),
})
    .transform(({ project, ref }) => {
    const dep = {
        datasource: gitlab_tags_1.GitlabTagsDatasource.id,
        depName: project,
        depType: 'repository',
    };
    if (!ref) {
        dep.skipReason = 'unspecified-version';
        return dep;
    }
    dep.currentValue = ref;
    return dep;
});
const GitlabIncludes = zod_1.z
    .union([GitlabInclude.transform(array_1.toArray), (0, schema_utils_1.LooseArray)(GitlabInclude)])
    .catch([]);
const GitlabRecord = zod_1.z.record(zod_1.z.unknown()).transform((obj) => {
    const { include, ...rest } = obj;
    const children = Object.values(rest);
    return { include, children };
});
exports.GitlabDocument = zod_1.z
    .union([GitlabRecord.transform(array_1.toArray), (0, schema_utils_1.LooseArray)(GitlabRecord)])
    .transform((docs) => docs
    .map(({ include, children }) => {
    const deps = GitlabIncludes.parse(include);
    const childrenDeps = exports.GitlabDocumentArray.parse(children);
    return [...childrenDeps, ...deps];
})
    .flat());
exports.GitlabDocumentArray = (0, schema_utils_1.LooseArray)(exports.GitlabDocument)
    .transform((x) => x.flat())
    .catch([]);
//# sourceMappingURL=schema.js.map