"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const global_1 = require("../../../config/global");
const logger_1 = require("../../../logger");
const regex_1 = require("../../../util/regex");
const yaml_1 = require("../../../util/yaml");
const schema_1 = require("./schema");
function extractPackageFile(content, packageFile) {
    const deps = [];
    const platform = global_1.GlobalConfig.get('platform');
    const endpoint = global_1.GlobalConfig.get('endpoint');
    const registryUrls = platform === 'gitlab' && endpoint
        ? [endpoint.replace((0, regex_1.regEx)(/\/api\/v4\/?/), '')]
        : null;
    try {
        const docs = (0, yaml_1.parseYaml)(content, { uniqueKeys: false });
        for (const dep of schema_1.GitlabDocumentArray.parse(docs)) {
            if (registryUrls) {
                dep.registryUrls = registryUrls;
            }
            deps.push(dep);
        }
    }
    catch (err) /* istanbul ignore next */ {
        if (err.stack?.startsWith('YAMLException:')) {
            logger_1.logger.debug({ err, packageFile }, 'YAML exception extracting GitLab CI includes');
        }
        else {
            logger_1.logger.debug({ err, packageFile }, 'Error extracting GitLab CI includes');
        }
    }
    if (!deps.length) {
        return null;
    }
    return { deps };
}
//# sourceMappingURL=extract.js.map