"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const logger_1 = require("../../../logger");
const schema_utils_1 = require("../../../util/schema-utils");
const flutter_version_1 = require("../../datasource/flutter-version");
const schema_1 = require("./schema");
function extractPackageFile(content, packageFile) {
    let flutterVersion;
    try {
        const config = schema_utils_1.Json.pipe(schema_1.FvmConfig).parse(content);
        flutterVersion = config.flutter ?? config.flutterSdkVersion;
        if (!flutterVersion) {
            logger_1.logger.debug({ contents: config }, 'FVM config does not have a flutter version specified');
            return null;
        }
    }
    catch (err) {
        logger_1.logger.debug({ packageFile, err }, 'Invalid FVM config');
        return null;
    }
    const dep = {
        depName: 'flutter',
        currentValue: flutterVersion,
        datasource: flutter_version_1.FlutterVersionDatasource.id,
        packageName: 'flutter/flutter',
    };
    return { deps: [dep] };
}
//# sourceMappingURL=extract.js.map