"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluxResource = exports.Kustomization = exports.OCIRepository = exports.GitRepository = exports.HelmChart = exports.HelmRepository = exports.HelmRelease = exports.KubernetesResource = void 0;
const zod_1 = require("zod");
exports.KubernetesResource = zod_1.z.object({
    apiVersion: zod_1.z.string(),
    kind: zod_1.z.string(),
    metadata: zod_1.z.object({
        name: zod_1.z.string(),
        // For Flux, the namespace property is optional, but matching HelmReleases to HelmRepositories would be
        // much more difficult without it (we'd have to examine the parent Kustomizations to discover the value),
        // so we require it for renovation.
        namespace: zod_1.z.string().optional(),
    }),
});
exports.HelmRelease = exports.KubernetesResource.extend({
    apiVersion: zod_1.z.string().startsWith('helm.toolkit.fluxcd.io/'),
    kind: zod_1.z.literal('HelmRelease'),
    spec: zod_1.z.object({
        chart: zod_1.z
            .object({
            spec: zod_1.z.object({
                chart: zod_1.z.string(),
                version: zod_1.z.string().optional(),
                sourceRef: zod_1.z
                    .object({
                    kind: zod_1.z.string().optional(),
                    name: zod_1.z.string().optional(),
                    namespace: zod_1.z.string().optional(),
                })
                    .optional(),
            }),
        })
            .optional(),
        chartRef: zod_1.z
            .object({
            kind: zod_1.z.string().optional(),
            name: zod_1.z.string().optional(),
            namespace: zod_1.z.string().optional(),
        })
            .optional(),
        values: zod_1.z.record(zod_1.z.unknown()).optional(),
    }),
});
exports.HelmRepository = exports.KubernetesResource.extend({
    apiVersion: zod_1.z.string().startsWith('source.toolkit.fluxcd.io/'),
    kind: zod_1.z.literal('HelmRepository'),
    spec: zod_1.z.object({
        url: zod_1.z.string(),
        type: zod_1.z.enum(['oci', 'default']).optional(),
    }),
});
exports.HelmChart = exports.KubernetesResource.extend({
    apiVersion: zod_1.z.string().startsWith('source.toolkit.fluxcd.io/'),
    kind: zod_1.z.literal('HelmChart'),
    spec: zod_1.z.object({
        chart: zod_1.z.string(),
        version: zod_1.z.string().optional(),
        sourceRef: zod_1.z.object({
            kind: zod_1.z.string().optional(),
            name: zod_1.z.string().optional(),
        }),
    }),
});
exports.GitRepository = exports.KubernetesResource.extend({
    apiVersion: zod_1.z.string().startsWith('source.toolkit.fluxcd.io/'),
    kind: zod_1.z.literal('GitRepository'),
    spec: zod_1.z.object({
        url: zod_1.z.string(),
        ref: zod_1.z
            .object({
            tag: zod_1.z.string().optional(),
            commit: zod_1.z.string().optional(),
        })
            .optional(),
    }),
});
exports.OCIRepository = exports.KubernetesResource.extend({
    apiVersion: zod_1.z.string().startsWith('source.toolkit.fluxcd.io/'),
    kind: zod_1.z.literal('OCIRepository'),
    spec: zod_1.z.object({
        url: zod_1.z.string(),
        ref: zod_1.z
            .object({
            tag: zod_1.z.string().optional(),
            digest: zod_1.z.string().optional(),
        })
            .optional(),
    }),
});
exports.Kustomization = exports.KubernetesResource.extend({
    apiVersion: zod_1.z.string().startsWith('kustomize.toolkit.fluxcd.io/'),
    kind: zod_1.z.literal('Kustomization'),
    spec: zod_1.z.object({
        images: zod_1.z
            .array(zod_1.z.object({
            name: zod_1.z.string(),
            newName: zod_1.z.string().optional(),
            newTag: zod_1.z.string().optional(),
            digest: zod_1.z.string().optional(),
        }))
            .optional(),
    }),
});
exports.FluxResource = exports.HelmRelease.or(exports.HelmRepository)
    .or(exports.HelmChart)
    .or(exports.GitRepository)
    .or(exports.OCIRepository)
    .or(exports.Kustomization);
//# sourceMappingURL=schema.js.map