"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.systemManifestHeaderRegex = exports.systemManifestFileNameRegex = void 0;
exports.isSystemManifest = isSystemManifest;
exports.collectHelmRepos = collectHelmRepos;
const regex_1 = require("../../../util/regex");
exports.systemManifestFileNameRegex = '(?:^|/)gotk-components\\.ya?ml$';
exports.systemManifestHeaderRegex = '#\\s*Flux\\s+Version:\\s*(\\S+)(?:\\s*#\\s*Components:\\s*([A-Za-z,-]+))?';
function isSystemManifest(file) {
    return (0, regex_1.regEx)(exports.systemManifestFileNameRegex).test(file);
}
function collectHelmRepos(manifests) {
    const helmRepositories = [];
    for (const manifest of manifests) {
        if (manifest.kind === 'resource') {
            for (const resource of manifest.resources) {
                if (resource.kind === 'HelmRepository') {
                    helmRepositories.push(resource);
                }
            }
        }
    }
    return helmRepositories;
}
//# sourceMappingURL=common.js.map