"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FleetFile = exports.GitRepo = void 0;
const zod_1 = require("zod");
const FleetHelmBlock = zod_1.z.object({
    chart: zod_1.z.string().optional(),
    repo: zod_1.z.string().optional(),
    version: zod_1.z.string().optional(),
    releaseName: zod_1.z.string().optional(),
});
/**
  Represent a GitRepo Kubernetes manifest of Fleet.
  @link https://fleet.rancher.io/gitrepo-add/#create-gitrepo-instance
 */
exports.GitRepo = zod_1.z.object({
    metadata: zod_1.z.object({
        name: zod_1.z.string(),
    }),
    kind: zod_1.z.string(),
    spec: zod_1.z.object({
        repo: zod_1.z.string().optional(),
        revision: zod_1.z.string().optional(),
    }),
});
/**
 Represent a Bundle configuration of Fleet, which is located in `fleet.yaml` files.
 @link https://fleet.rancher.io/gitrepo-structure/#fleetyaml
 */
exports.FleetFile = zod_1.z.object({
    helm: FleetHelmBlock,
    targetCustomizations: zod_1.z
        .array(zod_1.z.object({
        name: zod_1.z.string().optional(),
        helm: FleetHelmBlock.partial().optional(),
    }))
        .optional(),
});
//# sourceMappingURL=schema.js.map