import { z } from 'zod';
declare const FleetHelmBlock: z.ZodObject<{
    chart: z.ZodOptional<z.ZodString>;
    repo: z.ZodOptional<z.ZodString>;
    version: z.ZodOptional<z.ZodString>;
    releaseName: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    version?: string | undefined;
    repo?: string | undefined;
    chart?: string | undefined;
    releaseName?: string | undefined;
}, {
    version?: string | undefined;
    repo?: string | undefined;
    chart?: string | undefined;
    releaseName?: string | undefined;
}>;
export type FleetHelmBlock = z.infer<typeof FleetHelmBlock>;
/**
  Represent a GitRepo Kubernetes manifest of Fleet.
  @link https://fleet.rancher.io/gitrepo-add/#create-gitrepo-instance
 */
export declare const GitRepo: z.ZodObject<{
    metadata: z.ZodObject<{
        name: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        name: string;
    }, {
        name: string;
    }>;
    kind: z.ZodString;
    spec: z.ZodObject<{
        repo: z.ZodOptional<z.ZodString>;
        revision: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        revision?: string | undefined;
        repo?: string | undefined;
    }, {
        revision?: string | undefined;
        repo?: string | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    metadata: {
        name: string;
    };
    kind: string;
    spec: {
        revision?: string | undefined;
        repo?: string | undefined;
    };
}, {
    metadata: {
        name: string;
    };
    kind: string;
    spec: {
        revision?: string | undefined;
        repo?: string | undefined;
    };
}>;
export type GitRepo = z.infer<typeof GitRepo>;
/**
 Represent a Bundle configuration of Fleet, which is located in `fleet.yaml` files.
 @link https://fleet.rancher.io/gitrepo-structure/#fleetyaml
 */
export declare const FleetFile: z.ZodObject<{
    helm: z.ZodObject<{
        chart: z.ZodOptional<z.ZodString>;
        repo: z.ZodOptional<z.ZodString>;
        version: z.ZodOptional<z.ZodString>;
        releaseName: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        version?: string | undefined;
        repo?: string | undefined;
        chart?: string | undefined;
        releaseName?: string | undefined;
    }, {
        version?: string | undefined;
        repo?: string | undefined;
        chart?: string | undefined;
        releaseName?: string | undefined;
    }>;
    targetCustomizations: z.ZodOptional<z.ZodArray<z.ZodObject<{
        name: z.ZodOptional<z.ZodString>;
        helm: z.ZodOptional<z.ZodObject<{
            chart: z.ZodOptional<z.ZodOptional<z.ZodString>>;
            repo: z.ZodOptional<z.ZodOptional<z.ZodString>>;
            version: z.ZodOptional<z.ZodOptional<z.ZodString>>;
            releaseName: z.ZodOptional<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            version?: string | undefined;
            repo?: string | undefined;
            chart?: string | undefined;
            releaseName?: string | undefined;
        }, {
            version?: string | undefined;
            repo?: string | undefined;
            chart?: string | undefined;
            releaseName?: string | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        helm?: {
            version?: string | undefined;
            repo?: string | undefined;
            chart?: string | undefined;
            releaseName?: string | undefined;
        } | undefined;
        name?: string | undefined;
    }, {
        helm?: {
            version?: string | undefined;
            repo?: string | undefined;
            chart?: string | undefined;
            releaseName?: string | undefined;
        } | undefined;
        name?: string | undefined;
    }>, "many">>;
}, "strip", z.ZodTypeAny, {
    helm: {
        version?: string | undefined;
        repo?: string | undefined;
        chart?: string | undefined;
        releaseName?: string | undefined;
    };
    targetCustomizations?: {
        helm?: {
            version?: string | undefined;
            repo?: string | undefined;
            chart?: string | undefined;
            releaseName?: string | undefined;
        } | undefined;
        name?: string | undefined;
    }[] | undefined;
}, {
    helm: {
        version?: string | undefined;
        repo?: string | undefined;
        chart?: string | undefined;
        releaseName?: string | undefined;
    };
    targetCustomizations?: {
        helm?: {
            version?: string | undefined;
            repo?: string | undefined;
            chart?: string | undefined;
            releaseName?: string | undefined;
        } | undefined;
        name?: string | undefined;
    }[] | undefined;
}>;
export type FleetFile = z.infer<typeof FleetFile>;
export {};
