"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockerComposeFile = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const zod_1 = require("zod");
const DockerComposeService = zod_1.z.object({
    image: zod_1.z.string().optional(),
    build: zod_1.z
        .union([
        zod_1.z.string(),
        zod_1.z.object({
            context: zod_1.z.string().optional(),
            dockerfile: zod_1.z.string().optional(),
        }),
    ])
        .optional(),
});
const DockerComposeFileV1 = zod_1.z.record(DockerComposeService);
const DockerComposeFileModern = zod_1.z
    .object({
    /**
     *  compose does not use this strictly, so we shouldn't be either
     *  https://docs.docker.com/compose/compose-file/04-version-and-name/#version-top-level-element
     */
    version: zod_1.z.string().optional(),
    services: zod_1.z.record(DockerComposeService),
})
    // using catchall to capture fields starting with `x-` and collecting them in `extensions` field
    // might need to replace this with something better once zod v4 is stable
    .catchall(zod_1.z.unknown())
    .transform((obj) => {
    const { version, services, ...rest } = obj;
    let extensions;
    // collect extensions which have image field
    // https://docs.docker.com/reference/compose-file/extensions/
    for (const key in rest) {
        if (key.startsWith('x-')) {
            const value = rest[key];
            if (is_1.default.object(value) && 'image' in value && is_1.default.string(value.image)) {
                extensions ??= {};
                extensions[key] = { image: value.image };
            }
        }
    }
    return {
        version,
        services,
        ...(extensions && { extensions }),
    };
});
exports.DockerComposeFile = zod_1.z.union([
    DockerComposeFileModern,
    DockerComposeFileV1,
]);
//# sourceMappingURL=schema.js.map