"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DevboxSchema = void 0;
const zod_1 = require("zod");
const logger_1 = require("../../../logger");
const schema_utils_1 = require("../../../util/schema-utils");
const devbox_1 = require("../../datasource/devbox");
const devbox_2 = require("../../versioning/devbox");
const DevboxEntry = zod_1.z
    .array(zod_1.z.string())
    .min(1)
    .transform(([depName, currentValue]) => {
    const dep = {
        datasource: devbox_1.DevboxDatasource.id,
        depName,
    };
    if (!currentValue) {
        logger_1.logger.trace({ depName }, 'Devbox: skipping invalid devbox dependency in devbox JSON file.');
        dep.skipReason = 'not-a-version';
        return dep;
    }
    dep.currentValue = currentValue;
    if (!devbox_2.api.isValid(currentValue)) {
        logger_1.logger.debug({ depName }, 'Devbox: skipping invalid devbox dependency in devbox JSON file.');
        dep.skipReason = 'invalid-version';
        return dep;
    }
    return dep;
});
exports.DevboxSchema = schema_utils_1.Jsonc.pipe(zod_1.z.object({
    packages: zod_1.z
        .union([
        (0, schema_utils_1.LooseArray)(zod_1.z.string().transform((pkg) => pkg.split('@'))),
        (0, schema_utils_1.LooseRecord)(zod_1.z.union([
            zod_1.z.string(),
            zod_1.z
                .object({ version: zod_1.z.string() })
                .transform(({ version }) => version),
        ])).transform((obj) => Object.entries(obj)),
    ])
        .pipe((0, schema_utils_1.LooseArray)(DevboxEntry)),
}))
    .transform(({ packages }) => packages)
    .catch((0, schema_utils_1.withDebugMessage)([], 'Devbox: does not match schema'));
//# sourceMappingURL=schema.js.map