"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const logger_1 = require("../../../logger");
const schema_1 = require("./schema");
function extractPackageFile(content, packageFile) {
    logger_1.logger.trace('devbox.extractPackageFile()');
    const deps = (0, logger_1.withMeta)({ packageFile }, () => schema_1.DevboxSchema.parse(content));
    if (!deps.length) {
        return null;
    }
    return { deps };
}
//# sourceMappingURL=extract.js.map