"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validMatchFields = void 0;
exports.isValidDependency = isValidDependency;
exports.checkIsValidDependency = checkIsValidDependency;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const logger_1 = require("../../../logger");
exports.validMatchFields = [
    'depName',
    'packageName',
    'currentValue',
    'currentDigest',
    'datasource',
    'versioning',
    'extractVersion',
    'registryUrl',
    'depType',
    'indentation',
];
function isValidDependency({ depName, currentValue, currentDigest, packageName, datasource, }) {
    // check if all the fields are set
    return ((is_1.default.nonEmptyStringAndNotWhitespace(depName) ||
        is_1.default.nonEmptyStringAndNotWhitespace(packageName)) &&
        (is_1.default.nonEmptyStringAndNotWhitespace(currentDigest) ||
            is_1.default.nonEmptyStringAndNotWhitespace(currentValue)) &&
        is_1.default.nonEmptyStringAndNotWhitespace(datasource));
}
function checkIsValidDependency(dep, packageFile, manager) {
    const isValid = isValidDependency(dep);
    if (!isValid) {
        const meta = {
            packageDependency: dep,
            packageFile,
            manager,
        };
        logger_1.logger.trace(meta, 'Discovered a package dependency, but it did not pass validation. Discarding');
        return isValid;
    }
    return isValid;
}
//# sourceMappingURL=utils.js.map