"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDependency = createDependency;
exports.regexMatchAll = regexMatchAll;
exports.mergeGroups = mergeGroups;
exports.mergeExtractionTemplate = mergeExtractionTemplate;
const tslib_1 = require("tslib");
const node_url_1 = require("node:url");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const datasource_migration_1 = require("../../../../config/migrations/custom/datasource-migration");
const logger_1 = require("../../../../logger");
const template = tslib_1.__importStar(require("../../../../util/template"));
const utils_1 = require("../utils");
function updateDependency(dependency, field, value) {
    switch (field) {
        case 'registryUrl':
            // check if URL is valid and pack inside an array
            try {
                const url = new node_url_1.URL(value).toString();
                dependency.registryUrls = [url];
            }
            catch {
                logger_1.logger.warn({ value }, 'Invalid regex manager registryUrl');
            }
            break;
        case 'datasource':
            dependency.datasource = (0, datasource_migration_1.migrateDatasource)(value);
            break;
        case 'indentation':
            dependency.indentation = is_1.default.emptyStringOrWhitespace(value) ? value : '';
            break;
        default:
            dependency[field] = value;
            break;
    }
}
function createDependency(extractionTemplate, config, dep) {
    const dependency = dep ?? {};
    const { groups, replaceString } = extractionTemplate;
    for (const field of utils_1.validMatchFields) {
        const fieldTemplate = `${field}Template`;
        const tmpl = config[fieldTemplate];
        if (tmpl) {
            try {
                const compiled = template.compile(tmpl, groups, false);
                updateDependency(dependency, field, compiled);
            }
            catch {
                logger_1.logger.warn({ template: tmpl }, 'Error compiling template for custom manager');
                return null;
            }
        }
        else if (groups[field]) {
            updateDependency(dependency, field, groups[field]);
        }
    }
    dependency.replaceString = replaceString;
    return dependency;
}
function regexMatchAll(regex, content) {
    const matches = [];
    let matchResult;
    let iterations = 0;
    const maxIterations = 10000;
    do {
        matchResult = regex.exec(content);
        if (matchResult) {
            matches.push(matchResult);
        }
        iterations += 1;
    } while (matchResult && iterations < maxIterations);
    if (iterations === maxIterations) {
        logger_1.logger.warn('Max iterations reached for matchStrings');
    }
    return matches;
}
function mergeGroups(mergedGroup, secondGroup) {
    return { ...mergedGroup, ...secondGroup };
}
function mergeExtractionTemplate(base, addition) {
    return {
        groups: mergeGroups(base.groups, addition.groups),
        replaceString: addition.replaceString ?? base.replaceString,
    };
}
//# sourceMappingURL=utils.js.map